/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.driver.internal.packstream.PackInput;
import org.neo4j.driver.internal.packstream.PackStream;

public class BufferedChannelInput
implements PackInput {
    private final ByteBuffer buffer;
    private ReadableByteChannel channel;
    private static final int DEFAULT_BUFFER_CAPACITY = 8192;

    public BufferedChannelInput(ReadableByteChannel ch) {
        this(8192, ch);
    }

    public BufferedChannelInput(int bufferCapacity, ReadableByteChannel ch) {
        this.buffer = ByteBuffer.allocate(bufferCapacity).order(ByteOrder.BIG_ENDIAN);
        this.buffer.limit(0);
        this.channel = ch;
    }

    public byte readByte() throws IOException {
        this.ensure(1);
        return this.buffer.get();
    }

    public short readShort() throws IOException {
        this.ensure(2);
        return this.buffer.getShort();
    }

    public int readInt() throws IOException {
        this.ensure(4);
        return this.buffer.getInt();
    }

    public long readLong() throws IOException {
        this.ensure(8);
        return this.buffer.getLong();
    }

    public double readDouble() throws IOException {
        this.ensure(8);
        return this.buffer.getDouble();
    }

    public void readBytes(byte[] into, int index, int toRead) throws IOException {
        int endIndex = index + toRead;
        while (index < endIndex) {
            toRead = Math.min(this.buffer.remaining(), endIndex - index);
            this.buffer.get(into, index, toRead);
            if (this.buffer.remaining() != 0 || (index += toRead) >= endIndex) continue;
            this.attempt(endIndex - index);
            if (this.buffer.remaining() != 0) continue;
            throw new PackStream.EndOfStream("Expected " + (endIndex - index) + " bytes available, but no more bytes accessible from underlying stream.");
        }
    }

    public byte peekByte() throws IOException {
        this.ensure(1);
        return this.buffer.get(this.buffer.position());
    }

    private boolean attempt(int numBytes) throws IOException {
        int count;
        if (this.buffer.remaining() >= numBytes) {
            return true;
        }
        if (this.buffer.remaining() > 0) {
            this.buffer.compact();
        } else {
            this.buffer.clear();
        }
        while ((count = this.channel.read(this.buffer)) >= 0 && this.buffer.position() < numBytes && this.buffer.remaining() != 0) {
        }
        this.buffer.flip();
        return this.buffer.remaining() >= numBytes;
    }

    private void ensure(int numBytes) throws IOException {
        if (!this.attempt(numBytes)) {
            throw new PackStream.EndOfStream("Unexpected end of stream while trying to read " + numBytes + " bytes.");
        }
    }
}

