/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util.io;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Config;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.ConnectionSettings;
import org.neo4j.driver.internal.async.connection.BootstrapFactory;
import org.neo4j.driver.internal.async.connection.ChannelConnector;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.metrics.MetricsProvider;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.DriverFactoryWithClock;
import org.neo4j.driver.internal.util.io.ChannelTrackingConnector;
import org.neo4j.driver.net.ServerAddress;

public class ChannelTrackingDriverFactory
extends DriverFactoryWithClock {
    private final List<Channel> channels = new CopyOnWriteArrayList<Channel>();
    private final int eventLoopThreads;
    private ConnectionPool pool;

    public ChannelTrackingDriverFactory() {
        this(0, Clock.SYSTEM);
    }

    public ChannelTrackingDriverFactory(Clock clock) {
        this(0, clock);
    }

    public ChannelTrackingDriverFactory(int eventLoopThreads, Clock clock) {
        super(clock);
        this.eventLoopThreads = eventLoopThreads;
    }

    protected Bootstrap createBootstrap(int size) {
        return BootstrapFactory.newBootstrap((int)this.eventLoopThreads);
    }

    protected final ChannelConnector createConnector(ConnectionSettings settings, SecurityPlan securityPlan, Config config, Clock clock, RoutingContext routingContext) {
        return this.createChannelTrackingConnector(this.createRealConnector(settings, securityPlan, config, clock, routingContext));
    }

    protected final ConnectionPool createConnectionPool(AuthToken authToken, SecurityPlan securityPlan, Bootstrap bootstrap, MetricsProvider metricsProvider, Config config, boolean ownsEventLoopGroup, RoutingContext routingContext) {
        this.pool = super.createConnectionPool(authToken, securityPlan, bootstrap, metricsProvider, config, ownsEventLoopGroup, routingContext);
        return this.pool;
    }

    protected ChannelConnector createRealConnector(ConnectionSettings settings, SecurityPlan securityPlan, Config config, Clock clock, RoutingContext routingContext) {
        return super.createConnector(settings, securityPlan, config, clock, routingContext);
    }

    private ChannelTrackingConnector createChannelTrackingConnector(ChannelConnector connector) {
        return new ChannelTrackingConnector(connector, this.channels);
    }

    public List<Channel> channels() {
        return new ArrayList<Channel>(this.channels);
    }

    public List<Channel> pollChannels() {
        ArrayList<Channel> result = new ArrayList<Channel>(this.channels);
        this.channels.clear();
        return result;
    }

    public int activeChannels(BoltServerAddress address) {
        return this.pool == null ? 0 : this.pool.inUseConnections((ServerAddress)address);
    }
}

