/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util.messaging;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicNode;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.mockito.Mockito;
import org.neo4j.driver.internal.async.inbound.ByteBufInput;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.ResponseMessageHandler;
import org.neo4j.driver.internal.messaging.response.FailureMessage;
import org.neo4j.driver.internal.messaging.response.IgnoredMessage;
import org.neo4j.driver.internal.messaging.response.RecordMessage;
import org.neo4j.driver.internal.messaging.response.SuccessMessage;
import org.neo4j.driver.internal.packstream.PackInput;
import org.neo4j.driver.internal.util.io.ByteBufOutput;
import org.neo4j.driver.internal.util.messaging.KnowledgeableMessageFormat;

public abstract class AbstractMessageReaderTestBase {
    @TestFactory
    Stream<DynamicNode> shouldReadSupportedMessages() {
        return this.supportedMessages().map(message -> DynamicTest.dynamicTest((String)message.toString(), () -> this.testSupportedMessageReading((Message)message)));
    }

    private void testSupportedMessageReading(Message message) throws IOException {
        ResponseMessageHandler handler = this.testMessageReading(message);
        if (message instanceof SuccessMessage) {
            SuccessMessage successMessage = (SuccessMessage)message;
            ((ResponseMessageHandler)Mockito.verify((Object)handler)).handleSuccessMessage(successMessage.metadata());
        } else if (message instanceof FailureMessage) {
            FailureMessage failureMessage = (FailureMessage)message;
            ((ResponseMessageHandler)Mockito.verify((Object)handler)).handleFailureMessage(failureMessage.code(), failureMessage.message());
        } else if (message instanceof IgnoredMessage) {
            ((ResponseMessageHandler)Mockito.verify((Object)handler)).handleIgnoredMessage();
        } else if (message instanceof RecordMessage) {
            RecordMessage recordMessage = (RecordMessage)message;
            ((ResponseMessageHandler)Mockito.verify((Object)handler)).handleRecordMessage(recordMessage.fields());
        } else {
            Assertions.fail((String)("Unsupported message type " + message.getClass().getSimpleName()));
        }
    }

    @TestFactory
    Stream<DynamicNode> shouldFailToReadUnsupportedMessages() {
        return this.unsupportedMessages().map(message -> DynamicTest.dynamicTest((String)message.toString(), () -> this.testUnsupportedMessageReading((Message)message)));
    }

    private void testUnsupportedMessageReading(Message message) {
        Assertions.assertThrows(IOException.class, () -> this.testMessageReading(message));
    }

    protected abstract Stream<Message> supportedMessages();

    protected abstract Stream<Message> unsupportedMessages();

    protected abstract MessageFormat.Reader newReader(PackInput var1);

    protected ResponseMessageHandler testMessageReading(Message message) throws IOException {
        PackInput input = this.newInputWith(message);
        MessageFormat.Reader reader = this.newReader(input);
        ResponseMessageHandler handler = (ResponseMessageHandler)Mockito.mock(ResponseMessageHandler.class);
        reader.read(handler);
        return handler;
    }

    private PackInput newInputWith(Message message) throws IOException {
        ByteBuf buffer = Unpooled.buffer();
        KnowledgeableMessageFormat messageFormat = new KnowledgeableMessageFormat();
        if (this.isDateTimeUtcEnabled()) {
            messageFormat.enableDateTimeUtc();
        }
        MessageFormat.Writer writer = messageFormat.newWriter(new ByteBufOutput(buffer));
        writer.write(message);
        ByteBufInput input = new ByteBufInput();
        input.start(buffer);
        return input;
    }

    protected boolean isDateTimeUtcEnabled() {
        return false;
    }
}

