/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import java.time.LocalTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.exceptions.value.Uncoercible;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.value.LocalTimeValue;

class LocalTimeValueTest {
    LocalTimeValueTest() {
    }

    @Test
    void shouldHaveCorrectType() {
        LocalTime time = LocalTime.of(23, 59, 59);
        LocalTimeValue timeValue = new LocalTimeValue(time);
        Assertions.assertEquals((Object)InternalTypeSystem.TYPE_SYSTEM.LOCAL_TIME(), (Object)timeValue.type());
    }

    @Test
    void shouldSupportAsObject() {
        LocalTime time = LocalTime.of(1, 17, 59, 999);
        LocalTimeValue timeValue = new LocalTimeValue(time);
        Assertions.assertEquals((Object)time, (Object)timeValue.asObject());
    }

    @Test
    void shouldSupportAsLocalTime() {
        LocalTime time = LocalTime.of(12, 59, 12, 999999999);
        LocalTimeValue timeValue = new LocalTimeValue(time);
        Assertions.assertEquals((Object)time, (Object)timeValue.asLocalTime());
    }

    @Test
    void shouldNotSupportAsLong() {
        LocalTime time = LocalTime.now();
        LocalTimeValue timeValue = new LocalTimeValue(time);
        Assertions.assertThrows(Uncoercible.class, () -> ((LocalTimeValue)timeValue).asLong());
    }
}

