/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.types.TypeConstructor;
import org.neo4j.driver.internal.util.ValueFactory;
import org.neo4j.driver.internal.value.NodeValue;

class NodeValueTest {
    NodeValueTest() {
    }

    @Test
    void shouldHaveSensibleToString() {
        Assertions.assertEquals((Object)"node<1234>", (Object)ValueFactory.emptyNodeValue().toString());
        Assertions.assertEquals((Object)"node<1234>", (Object)ValueFactory.filledNodeValue().toString());
    }

    @Test
    void shouldHaveCorrectPropertyCount() {
        Assertions.assertEquals((int)0, (int)ValueFactory.emptyNodeValue().size());
        Assertions.assertEquals((int)1, (int)ValueFactory.filledNodeValue().size());
    }

    @Test
    void shouldNotBeNull() {
        Assertions.assertFalse((boolean)ValueFactory.emptyNodeValue().isNull());
    }

    @Test
    void shouldHaveCorrectType() {
        MatcherAssert.assertThat((Object)ValueFactory.emptyNodeValue().type(), (Matcher)CoreMatchers.equalTo((Object)InternalTypeSystem.TYPE_SYSTEM.NODE()));
    }

    @Test
    void shouldTypeAsNode() {
        NodeValue value = ValueFactory.emptyNodeValue();
        MatcherAssert.assertThat((Object)value.typeConstructor(), (Matcher)CoreMatchers.equalTo((Object)TypeConstructor.NODE));
    }
}

