/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.types.TypeConstructor;
import org.neo4j.driver.internal.value.InternalValue;
import org.neo4j.driver.internal.value.NullValue;
import org.neo4j.driver.types.MapAccessor;

class NullValueTest {
    NullValueTest() {
    }

    @Test
    void shouldEqualItself() {
        MatcherAssert.assertThat((Object)NullValue.NULL, (Matcher)Matchers.equalTo((Object)NullValue.NULL));
    }

    @Test
    void shouldBeNull() {
        Assertions.assertTrue((boolean)NullValue.NULL.isNull());
    }

    @Test
    void shouldTypeAsNull() {
        MatcherAssert.assertThat((Object)((InternalValue)NullValue.NULL).typeConstructor(), (Matcher)Matchers.equalTo((Object)TypeConstructor.NULL));
    }

    @Test
    void shouldReturnNativeTypesAsDefaultValue() {
        Value value = NullValue.NULL;
        MatcherAssert.assertThat((Object)value.asString("string value"), (Matcher)Matchers.equalTo((Object)"string value"));
        MatcherAssert.assertThat((Object)value.asBoolean(false), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)value.asBoolean(true), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)value.asInt(10), (Matcher)Matchers.equalTo((Object)10));
        MatcherAssert.assertThat((Object)value.asLong(100L), (Matcher)Matchers.equalTo((Object)100L));
        MatcherAssert.assertThat((Object)Float.valueOf(value.asFloat(10.4f)), (Matcher)Matchers.equalTo((Object)Float.valueOf(10.4f)));
        MatcherAssert.assertThat((Object)value.asDouble(10.1), (Matcher)Matchers.equalTo((Object)10.1));
        MatcherAssert.assertThat((Object)value.asByteArray(new byte[]{1, 2}), (Matcher)Matchers.equalTo((Object)new byte[]{1, 2}));
        MatcherAssert.assertThat((Object)value.asList(Collections.emptyList()), (Matcher)Matchers.equalTo(Collections.emptyList()));
        MatcherAssert.assertThat((Object)value.asList(Values.ofValue(), Collections.emptyList()), (Matcher)Matchers.equalTo(Collections.emptyList()));
        MatcherAssert.assertThat((Object)value.asMap(Collections.emptyMap()), (Matcher)Matchers.equalTo(Collections.emptyMap()));
        MatcherAssert.assertThat((Object)value.asMap(Values.ofValue(), Collections.emptyMap()), (Matcher)Matchers.equalTo(Collections.emptyMap()));
        NullValueTest.assertAsWithDefaultValueReturnDefault(arg_0 -> ((Value)value).asPoint(arg_0), Values.point((int)1234, (double)1.0, (double)2.0).asPoint());
        NullValueTest.assertAsWithDefaultValueReturnDefault(arg_0 -> ((Value)value).asLocalDate(arg_0), LocalDate.now());
        NullValueTest.assertAsWithDefaultValueReturnDefault(arg_0 -> ((Value)value).asOffsetTime(arg_0), OffsetTime.now());
        NullValueTest.assertAsWithDefaultValueReturnDefault(arg_0 -> ((Value)value).asLocalTime(arg_0), LocalTime.now());
        NullValueTest.assertAsWithDefaultValueReturnDefault(arg_0 -> ((Value)value).asLocalDateTime(arg_0), LocalDateTime.now());
        NullValueTest.assertAsWithDefaultValueReturnDefault(arg_0 -> ((Value)value).asOffsetDateTime(arg_0), OffsetDateTime.now());
        NullValueTest.assertAsWithDefaultValueReturnDefault(arg_0 -> ((Value)value).asZonedDateTime(arg_0), ZonedDateTime.now());
        NullValueTest.assertAsWithDefaultValueReturnDefault(arg_0 -> ((Value)value).asIsoDuration(arg_0), Values.isoDuration((long)1L, (long)2L, (long)3L, (int)4).asIsoDuration());
    }

    @Test
    void shouldReturnAsNull() {
        NullValueTest.assertComputeOrDefaultReturnNull(Value::asObject);
        NullValueTest.assertComputeOrDefaultReturnNull(Value::asNumber);
        NullValueTest.assertComputeOrDefaultReturnNull(Value::asEntity);
        NullValueTest.assertComputeOrDefaultReturnNull(Value::asNode);
        NullValueTest.assertComputeOrDefaultReturnNull(Value::asRelationship);
        NullValueTest.assertComputeOrDefaultReturnNull(Value::asPath);
        NullValueTest.assertComputeOrDefaultReturnNull(Value::asString);
        NullValueTest.assertComputeOrDefaultReturnNull(Value::asByteArray);
        NullValueTest.assertComputeOrDefaultReturnNull(Value::asList);
        NullValueTest.assertComputeOrDefaultReturnNull(v -> v.asList(Values.ofValue()));
        NullValueTest.assertComputeOrDefaultReturnNull(MapAccessor::asMap);
        NullValueTest.assertComputeOrDefaultReturnNull(v -> v.asMap(Values.ofValue()));
        NullValueTest.assertComputeOrDefaultReturnNull(Value::asPoint);
        NullValueTest.assertComputeOrDefaultReturnNull(Value::asLocalDate);
        NullValueTest.assertComputeOrDefaultReturnNull(Value::asOffsetTime);
        NullValueTest.assertComputeOrDefaultReturnNull(Value::asLocalTime);
        NullValueTest.assertComputeOrDefaultReturnNull(Value::asLocalDateTime);
        NullValueTest.assertComputeOrDefaultReturnNull(Value::asOffsetTime);
        NullValueTest.assertComputeOrDefaultReturnNull(Value::asZonedDateTime);
        NullValueTest.assertComputeOrDefaultReturnNull(Value::asIsoDuration);
    }

    @Test
    void shouldReturnAsDefaultValue() {
        NullValueTest.assertComputeOrDefaultReturnDefault(Value::asObject, "null string");
        NullValueTest.assertComputeOrDefaultReturnDefault(Value::asNumber, 10);
    }

    private static <T> void assertComputeOrDefaultReturnDefault(Function<Value, T> f, T defaultAndExpectedValue) {
        Value value = NullValue.NULL;
        MatcherAssert.assertThat((Object)value.computeOrDefault(f, defaultAndExpectedValue), (Matcher)Matchers.equalTo(defaultAndExpectedValue));
    }

    private static <T> void assertComputeOrDefaultReturnNull(Function<Value, T> f) {
        NullValueTest.assertComputeOrDefaultReturnDefault(f, null);
    }

    private static <T> void assertAsWithDefaultValueReturnDefault(Function<T, T> map, T defaultValue) {
        MatcherAssert.assertThat(map.apply(defaultValue), (Matcher)Matchers.equalTo(defaultValue));
    }
}

