/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.types.TypeConstructor;
import org.neo4j.driver.internal.value.StringValue;
import org.neo4j.driver.types.TypeSystem;

class StringValueTest {
    private TypeSystem typeSystem = InternalTypeSystem.TYPE_SYSTEM;

    StringValueTest() {
    }

    @Test
    void testStringValue() {
        StringValue value = new StringValue("Spongebob");
        MatcherAssert.assertThat((Object)value.asString(), (Matcher)CoreMatchers.equalTo((Object)"Spongebob"));
    }

    @Test
    void testIsString() {
        StringValue value = new StringValue("Spongebob");
        MatcherAssert.assertThat((Object)this.typeSystem.STRING().isTypeOf((Value)value), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    void testEquals() {
        StringValue firstValue = new StringValue("Spongebob");
        StringValue secondValue = new StringValue("Spongebob");
        MatcherAssert.assertThat((Object)firstValue, (Matcher)CoreMatchers.equalTo((Object)secondValue));
    }

    @Test
    void testHashCode() {
        StringValue value = new StringValue("Spongebob");
        MatcherAssert.assertThat((Object)value.hashCode(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    void shouldNotBeNull() {
        StringValue value = new StringValue("Spongebob");
        Assertions.assertFalse((boolean)value.isNull());
    }

    @Test
    void shouldTypeAsString() {
        StringValue value = new StringValue("Spongebob");
        MatcherAssert.assertThat((Object)value.typeConstructor(), (Matcher)CoreMatchers.equalTo((Object)TypeConstructor.STRING));
    }

    @Test
    void shouldHaveStringType() {
        StringValue value = new StringValue("Spongebob");
        MatcherAssert.assertThat((Object)value.type(), (Matcher)CoreMatchers.equalTo((Object)InternalTypeSystem.TYPE_SYSTEM.STRING()));
    }
}

