/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.stress;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.summary.ResultSummary;

public abstract class AbstractContext {
    private volatile boolean stopped;
    private volatile Bookmark bookmark;
    private final AtomicLong readNodesCount = new AtomicLong();
    private final AtomicLong createdNodesCount = new AtomicLong();
    private final AtomicInteger bookmarkFailures = new AtomicInteger();

    public final boolean isStopped() {
        return this.stopped;
    }

    public final void stop() {
        this.stopped = true;
    }

    public final Bookmark getBookmark() {
        return this.bookmark;
    }

    public final void setBookmark(Bookmark bookmark) {
        this.bookmark = bookmark;
    }

    public final void nodeCreated() {
        this.createdNodesCount.incrementAndGet();
    }

    public final long getCreatedNodesCount() {
        return this.createdNodesCount.get();
    }

    public final void readCompleted(ResultSummary summary) {
        this.readNodesCount.incrementAndGet();
    }

    public long getReadNodesCount() {
        return this.readNodesCount.get();
    }

    public final void bookmarkFailed() {
        this.bookmarkFailures.incrementAndGet();
    }

    public final int getBookmarkFailures() {
        return this.bookmarkFailures.get();
    }
}

