/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.stress;

import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Driver;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.reactive.RxSession;
import org.neo4j.driver.stress.AbstractContext;
import org.neo4j.driver.stress.RxCommand;

public abstract class AbstractRxQuery<C extends AbstractContext>
implements RxCommand<C> {
    protected final Driver driver;
    protected final boolean useBookmark;

    public AbstractRxQuery(Driver driver, boolean useBookmark) {
        this.driver = driver;
        this.useBookmark = useBookmark;
    }

    public RxSession newSession(AccessMode mode, C context) {
        if (this.useBookmark) {
            return this.driver.rxSession(SessionConfig.builder().withDefaultAccessMode(mode).withBookmarks(new Bookmark[]{((AbstractContext)context).getBookmark()}).build());
        }
        return this.driver.rxSession(SessionConfig.builder().withDefaultAccessMode(mode).build());
    }
}

