/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.stress;

import java.util.concurrent.CompletionStage;
import org.junit.jupiter.api.Assertions;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Driver;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.stress.AbstractAsyncQuery;
import org.neo4j.driver.stress.AbstractContext;
import org.neo4j.driver.stress.AbstractStressTestBase;

public class AsyncWriteQuery<C extends AbstractContext>
extends AbstractAsyncQuery<C> {
    private AbstractStressTestBase<C> stressTest;

    public AsyncWriteQuery(AbstractStressTestBase<C> stressTest, Driver driver, boolean useBookmark) {
        super(driver, useBookmark);
        this.stressTest = stressTest;
    }

    @Override
    public CompletionStage<Void> execute(C context) {
        AsyncSession session = this.newSession(AccessMode.WRITE, context);
        return session.runAsync("CREATE ()").thenCompose(ResultCursor::consumeAsync).handle((summary, error) -> {
            session.closeAsync();
            if (error != null) {
                this.handleError(Futures.completionExceptionCause((Throwable)error), context);
            } else {
                context.setBookmark(session.lastBookmark());
                Assertions.assertEquals((int)1, (int)summary.counters().nodesCreated());
                context.nodeCreated();
            }
            return null;
        });
    }

    private void handleError(Throwable error, C context) {
        if (!this.stressTest.handleWriteFailure(error, context)) {
            throw new RuntimeException(error);
        }
    }
}

