/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.stress;

import java.util.concurrent.CompletionStage;
import org.junit.jupiter.api.Assertions;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Driver;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.stress.AbstractAsyncQuery;
import org.neo4j.driver.stress.AbstractContext;
import org.neo4j.driver.stress.AbstractStressTestBase;
import org.neo4j.driver.summary.ResultSummary;

public class AsyncWriteQueryWithRetries<C extends AbstractContext>
extends AbstractAsyncQuery<C> {
    private final AbstractStressTestBase<C> stressTest;

    public AsyncWriteQueryWithRetries(AbstractStressTestBase<C> stressTest, Driver driver, boolean useBookmark) {
        super(driver, useBookmark);
        this.stressTest = stressTest;
    }

    @Override
    public CompletionStage<Void> execute(C context) {
        AsyncSession session = this.newSession(AccessMode.WRITE, context);
        CompletionStage txStage = session.writeTransactionAsync(tx -> tx.runAsync("CREATE ()").thenCompose(ResultCursor::consumeAsync));
        return txStage.thenApply(resultSummary -> this.processResultSummary((ResultSummary)resultSummary, context)).handle((nothing, throwable) -> this.recordAndRethrowThrowable((Throwable)throwable, context)).whenComplete((nothing, throwable) -> this.finalizeSession(session, context));
    }

    private Void processResultSummary(ResultSummary resultSummary, C context) {
        Assertions.assertEquals((int)1, (int)resultSummary.counters().nodesCreated());
        ((AbstractContext)context).nodeCreated();
        return null;
    }

    private Void recordAndRethrowThrowable(Throwable throwable, C context) {
        if (throwable != null) {
            this.stressTest.handleWriteFailure(throwable, context);
            throw new RuntimeException(throwable);
        }
        return null;
    }

    private void finalizeSession(AsyncSession session, C context) {
        ((AbstractContext)context).setBookmark(session.lastBookmark());
        session.closeAsync();
    }
}

