/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.stress;

import org.junit.jupiter.api.Assertions;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Session;
import org.neo4j.driver.stress.AbstractBlockingQuery;
import org.neo4j.driver.stress.AbstractContext;
import org.neo4j.driver.stress.AbstractStressTestBase;
import org.neo4j.driver.summary.ResultSummary;

public class BlockingWriteQueryWithRetries<C extends AbstractContext>
extends AbstractBlockingQuery<C> {
    private final AbstractStressTestBase<C> stressTest;

    public BlockingWriteQueryWithRetries(AbstractStressTestBase<C> stressTest, Driver driver, boolean useBookmark) {
        super(driver, useBookmark);
        this.stressTest = stressTest;
    }

    @Override
    public void execute(C context) {
        try (Session session = this.newSession(AccessMode.WRITE, context);){
            ResultSummary resultSummary = (ResultSummary)session.writeTransaction(tx -> tx.run("CREATE ()").consume());
            Assertions.assertEquals((int)1, (int)resultSummary.counters().nodesCreated());
            ((AbstractContext)context).nodeCreated();
            ((AbstractContext)context).setBookmark(session.lastBookmark());
        }
        catch (RuntimeException error) {
            this.stressTest.handleWriteFailure(error, context);
            throw error;
        }
    }
}

