/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.stress;

import java.net.URI;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.exceptions.SecurityException;
import org.neo4j.driver.stress.AbstractContext;
import org.neo4j.driver.stress.BlockingCommand;

public class FailedAuth<C extends AbstractContext>
implements BlockingCommand<C> {
    private final URI clusterUri;
    private final Config config;

    public FailedAuth(URI clusterUri, Config config) {
        this.clusterUri = clusterUri;
        this.config = config;
    }

    @Override
    public void execute(C context) {
        Driver driver = GraphDatabase.driver((URI)this.clusterUri, (AuthToken)AuthTokens.basic((String)"wrongUsername", (String)"wrongPassword"), (Config)this.config);
        SecurityException e = (SecurityException)Assertions.assertThrows(SecurityException.class, () -> ((Driver)driver).verifyConnectivity());
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"authentication failure"));
        driver.close();
    }
}

