/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.stress;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.util.DaemonThreadFactory;
import org.neo4j.driver.util.DatabaseExtension;
import org.neo4j.driver.util.ParallelizableIT;

@ParallelizableIT
class SessionPoolingStressIT {
    @RegisterExtension
    static final DatabaseExtension neo4j = new DatabaseExtension();
    private static final int N_THREADS = 50;
    private static final int TEST_TIME = 10000;
    private static final List<String> QUERIES = Arrays.asList("RETURN 1295 + 42", "UNWIND range(1,10000) AS x CREATE (n {prop:x}) DELETE n ");
    private Driver driver;
    private ExecutorService executor;

    SessionPoolingStressIT() {
    }

    @BeforeEach
    void setUp() {
        this.executor = Executors.newFixedThreadPool(50, DaemonThreadFactory.daemon(this.getClass().getSimpleName() + "-thread-"));
    }

    @AfterEach
    void tearDown() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        if (this.driver != null) {
            this.driver.close();
        }
    }

    @Test
    void shouldWorkFine() throws Throwable {
        Config config = Config.builder().withoutEncryption().build();
        this.driver = GraphDatabase.driver((URI)neo4j.uri(), (AuthToken)neo4j.authToken(), (Config)config);
        AtomicBoolean stop = new AtomicBoolean();
        AtomicReference<Throwable> failureReference = new AtomicReference<Throwable>();
        this.doWork(stop, failureReference);
        Thread.sleep(10000L);
        stop.set(true);
        this.executor.shutdown();
        Assertions.assertTrue((boolean)this.executor.awaitTermination(90L, TimeUnit.SECONDS));
        Throwable failure = failureReference.get();
        if (failure != null) {
            throw new AssertionError("Some workers have failed", failure);
        }
    }

    private void doWork(AtomicBoolean stop, AtomicReference<Throwable> failure) {
        for (int i = 0; i < 50; ++i) {
            this.executor.execute(new Worker(this.driver, stop, failure));
        }
    }

    private class Worker
    implements Runnable {
        private final Random random = ThreadLocalRandom.current();
        private final Driver driver;
        private final AtomicBoolean stop;
        private final AtomicReference<Throwable> failureReference;

        Worker(Driver driver, AtomicBoolean stop, AtomicReference<Throwable> failureReference) {
            this.driver = driver;
            this.stop = stop;
            this.failureReference = failureReference;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block7: {
                try {
                    while (!this.stop.get()) {
                        for (String query : QUERIES) {
                            this.runQuery(query);
                        }
                    }
                }
                catch (Throwable failure) {
                    Throwable firstFailure;
                    if (this.failureReference.compareAndSet(null, failure)) break block7;
                    Throwable throwable = firstFailure = this.failureReference.get();
                    synchronized (throwable) {
                        firstFailure.addSuppressed(failure);
                    }
                }
            }
        }

        private void runQuery(String query) throws InterruptedException {
            try (Session session = this.driver.session();){
                Result run = session.run(query);
                Thread.sleep(this.random.nextInt(100));
                run.consume();
                Thread.sleep(this.random.nextInt(100));
            }
        }
    }
}

