/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.driver.util.DatabaseExtension;
import org.neo4j.driver.util.Neo4jRunner;

public class CertificateExtension
extends DatabaseExtension
implements AfterEachCallback {
    private Path originalKeyFile;
    private Path originalCertFile;

    @Override
    public void beforeEach(ExtensionContext context) throws Exception {
        super.beforeEach(context);
        this.originalKeyFile = Files.createTempFile("key-file-", "", new FileAttribute[0]);
        this.originalCertFile = Files.createTempFile("cert-file-", "", new FileAttribute[0]);
        Files.copy(this.tlsKeyFile().toPath(), this.originalKeyFile, StandardCopyOption.REPLACE_EXISTING);
        Files.copy(this.tlsCertFile().toPath(), this.originalCertFile, StandardCopyOption.REPLACE_EXISTING);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        if (!this.smallFileContentEquals(this.tlsKeyFile().toPath(), this.originalKeyFile) || !this.smallFileContentEquals(this.tlsCertFile().toPath(), this.originalCertFile)) {
            Neo4jRunner.debug("Restoring original key and certificate file after certificate test.");
            this.updateEncryptionKeyAndCert(this.originalKeyFile.toFile(), this.originalCertFile.toFile());
        }
        Files.deleteIfExists(this.originalKeyFile);
        Files.deleteIfExists(this.originalCertFile);
    }

    private boolean smallFileContentEquals(Path path, Path pathAnother) throws IOException {
        byte[] fileContent = Files.readAllBytes(path);
        byte[] fileContentAnother = Files.readAllBytes(pathAnother);
        return Arrays.equals(fileContent, fileContentAnother);
    }
}

