/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Objects;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.neo4j.driver.internal.InternalPair;
import org.neo4j.driver.internal.util.CertificateTool;
import org.neo4j.driver.util.FileTools;
import org.neo4j.driver.util.Pair;

public class CertificateUtil {
    private static final String DEFAULT_HOST_NAME = "localhost";
    private static final String DEFAULT_ENCRYPTION = "RSA";
    private static final Provider PROVIDER = new BouncyCastleProvider();

    private static KeyPair generateKeyPair() throws NoSuchProviderException, NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(DEFAULT_ENCRYPTION);
        keyPairGenerator.initialize(2048, new SecureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return keyPair;
    }

    private static X509Certificate generateCert(X500Name issuer, X500Name subject, KeyPair issuerKeys, PublicKey publicKey) throws GeneralSecurityException, OperatorCreationException, CertIOException {
        Date startDate = new Date(System.currentTimeMillis());
        Date endDate = new Date(System.currentTimeMillis() + 31536000000L);
        BigInteger serialNum = BigInteger.valueOf(System.currentTimeMillis());
        JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(issuer, serialNum, startDate, endDate, subject, publicKey);
        GeneralNames subjectAlternativeName = new GeneralNames(new GeneralName(2, DEFAULT_HOST_NAME));
        certBuilder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAlternativeName);
        certBuilder.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(true));
        ContentSigner signer = new JcaContentSignerBuilder("SHA512WithRSAEncryption").build(issuerKeys.getPrivate());
        X509CertificateHolder certHolder = certBuilder.build(signer);
        X509Certificate certificate = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHolder);
        certificate.verify(issuerKeys.getPublic());
        return certificate;
    }

    public static X509Certificate generateSelfSignedCertificate() throws GeneralSecurityException, OperatorCreationException, CertIOException {
        return new SelfSignedCertificateGenerator().certificate;
    }

    private static void writePem(String type, byte[] encodedContent, File path) throws IOException {
        if (path.getParentFile() != null && path.getParentFile().exists()) {
            path.getParentFile().mkdirs();
        }
        try (PemWriter writer = new PemWriter((Writer)new FileWriter(path));){
            writer.writeObject((PemObjectGenerator)new PemObject(type, encodedContent));
            writer.flush();
        }
    }

    public static CertificateKeyPair<File, File> createNewCertificateAndKeySignedBy(CertificateKeyPair<File, File> root) throws Throwable {
        Objects.requireNonNull(((CertificateKeyPair)root).certGenerator);
        File cert = FileTools.tempFile("driver", ".cert");
        File key = FileTools.tempFile("driver", ".key");
        CertificateSigningRequestGenerator csrGenerator = new CertificateSigningRequestGenerator();
        X509Certificate signedCert = ((CertificateKeyPair)root).certGenerator.sign(csrGenerator.certificateSigningRequest(), csrGenerator.publicKey());
        csrGenerator.savePrivateKey(key);
        CertificateTool.saveX509Cert((Certificate)signedCert, (File)cert);
        return new CertificateKeyPair<File, File>(cert, key);
    }

    public static CertificateKeyPair<File, File> createNewCertificateAndKey() throws Throwable {
        File cert = FileTools.tempFile("driver", ".cert");
        File key = FileTools.tempFile("driver", ".key");
        SelfSignedCertificateGenerator certGenerator = new SelfSignedCertificateGenerator();
        certGenerator.saveSelfSignedCertificate(cert);
        certGenerator.savePrivateKey(key);
        return new CertificateKeyPair<File, File>(cert, key, certGenerator);
    }

    static /* synthetic */ KeyPair access$000() throws NoSuchProviderException, NoSuchAlgorithmException {
        return CertificateUtil.generateKeyPair();
    }

    static {
        Security.addProvider(PROVIDER);
    }

    public static class CertificateKeyPair<C, K> {
        private final Pair<C, K> pair;
        private final SelfSignedCertificateGenerator certGenerator;

        public CertificateKeyPair(C cert, K key) {
            this(cert, key, null);
        }

        public CertificateKeyPair(C cert, K key, SelfSignedCertificateGenerator certGenerator) {
            this.pair = InternalPair.of(cert, key);
            this.certGenerator = certGenerator;
        }

        public K key() {
            return (K)this.pair.value();
        }

        public C cert() {
            return (C)this.pair.key();
        }

        public SelfSignedCertificateGenerator certGenerator() {
            return this.certGenerator;
        }

        public String toString() {
            return this.pair.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CertificateKeyPair that = (CertificateKeyPair)o;
            return this.pair.equals(that.pair);
        }

        public int hashCode() {
            return this.pair.hashCode();
        }
    }

    public static class CertificateSigningRequestGenerator {
        private final KeyPair keyPair;
        private final PKCS10CertificationRequest csr;

        public CertificateSigningRequestGenerator() throws NoSuchAlgorithmException, OperatorCreationException {
            KeyPairGenerator gen = KeyPairGenerator.getInstance(CertificateUtil.DEFAULT_ENCRYPTION);
            gen.initialize(2048, new SecureRandom());
            this.keyPair = gen.generateKeyPair();
            X500Principal subject = new X500Principal("CN=localhost");
            ContentSigner signGen = new JcaContentSignerBuilder("SHA512WithRSAEncryption").build(this.keyPair.getPrivate());
            JcaPKCS10CertificationRequestBuilder builder = new JcaPKCS10CertificationRequestBuilder(subject, this.keyPair.getPublic());
            this.csr = builder.build(signGen);
        }

        public PrivateKey privateKey() {
            return this.keyPair.getPrivate();
        }

        public PublicKey publicKey() {
            return this.keyPair.getPublic();
        }

        public PKCS10CertificationRequest certificateSigningRequest() {
            return this.csr;
        }

        public void savePrivateKey(File saveTo) throws IOException {
            CertificateUtil.writePem("PRIVATE KEY", this.keyPair.getPrivate().getEncoded(), saveTo);
        }
    }

    public static class SelfSignedCertificateGenerator {
        private final KeyPair keyPair = CertificateUtil.access$000();
        private final X509Certificate certificate = CertificateUtil.access$100(new X500Name("CN=localhost"), new X500Name("CN=localhost"), this.keyPair, this.keyPair.getPublic());

        public void savePrivateKey(File saveTo) throws IOException {
            CertificateUtil.writePem("PRIVATE KEY", this.keyPair.getPrivate().getEncoded(), saveTo);
        }

        public void saveSelfSignedCertificate(File saveTo) throws CertificateEncodingException, IOException {
            CertificateUtil.writePem("CERTIFICATE", this.certificate.getEncoded(), saveTo);
        }

        public X509Certificate sign(PKCS10CertificationRequest csr, PublicKey csrPublicKey) throws GeneralSecurityException, OperatorCreationException, CertIOException {
            return CertificateUtil.generateCert(X500Name.getInstance((Object)this.certificate.getSubjectX500Principal().getEncoded()), csr.getSubject(), this.keyPair, csrPublicKey);
        }
    }
}

