/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.util;

import io.netty.buffer.ByteBuf;
import io.netty.util.internal.PlatformDependent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.BookmarkHolder;
import org.neo4j.driver.internal.DatabaseNameUtil;
import org.neo4j.driver.internal.DefaultBookmarkHolder;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.async.connection.EventLoopGroupFactory;
import org.neo4j.driver.internal.handlers.BeginTxResponseHandler;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.messaging.BoltProtocolVersion;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.request.BeginMessage;
import org.neo4j.driver.internal.messaging.request.CommitMessage;
import org.neo4j.driver.internal.messaging.request.PullMessage;
import org.neo4j.driver.internal.messaging.request.RollbackMessage;
import org.neo4j.driver.internal.messaging.request.RunWithMetadataMessage;
import org.neo4j.driver.internal.messaging.v3.BoltProtocolV3;
import org.neo4j.driver.internal.messaging.v4.BoltProtocolV4;
import org.neo4j.driver.internal.messaging.v41.BoltProtocolV41;
import org.neo4j.driver.internal.messaging.v42.BoltProtocolV42;
import org.neo4j.driver.internal.messaging.v43.BoltProtocolV43;
import org.neo4j.driver.internal.messaging.v44.BoltProtocolV44;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.FixedRetryLogic;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.util.ServerVersion;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class TestUtil {
    public static final BoltProtocolVersion DEFAULT_TEST_PROTOCOL_VERSION = BoltProtocolV4.VERSION;
    public static final BoltProtocol DEFAULT_TEST_PROTOCOL = BoltProtocol.forVersion((BoltProtocolVersion)DEFAULT_TEST_PROTOCOL_VERSION);
    private static final long DEFAULT_WAIT_TIME_MS = TimeUnit.MINUTES.toMillis(2L);
    private static final String ALPHANUMERICS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz123456789";
    public static final Duration TX_TIMEOUT_TEST_TIMEOUT = Duration.ofSeconds(10L);

    private TestUtil() {
    }

    public static <T> List<T> await(Publisher<T> publisher) {
        return TestUtil.await(Flux.from(publisher));
    }

    public static <T> T await(Mono<T> publisher) {
        EventLoopGroupFactory.assertNotInEventLoopThread();
        return (T)publisher.block(Duration.ofMillis(DEFAULT_WAIT_TIME_MS));
    }

    public static <T> List<T> await(Flux<T> publisher) {
        EventLoopGroupFactory.assertNotInEventLoopThread();
        return (List)publisher.collectList().block(Duration.ofMillis(DEFAULT_WAIT_TIME_MS));
    }

    @SafeVarargs
    public static <T> List<T> awaitAll(CompletionStage<T> ... stages) {
        return TestUtil.awaitAll(Arrays.asList(stages));
    }

    public static <T> List<T> awaitAll(List<CompletionStage<T>> stages) {
        return stages.stream().map(TestUtil::await).collect(Collectors.toList());
    }

    public static <T> T await(CompletionStage<T> stage) {
        return TestUtil.await(stage.toCompletableFuture());
    }

    public static <T> T await(CompletableFuture<T> future) {
        return TestUtil.await(future);
    }

    public static void awaitAllFutures(List<Future<?>> futures) {
        for (Future<?> future : futures) {
            TestUtil.await(future);
        }
    }

    public static <T, U extends Future<T>> T await(U future) {
        try {
            return future.get(DEFAULT_WAIT_TIME_MS, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AssertionError("Interrupted while waiting for future: " + future, e);
        }
        catch (ExecutionException e) {
            PlatformDependent.throwException((Throwable)e.getCause());
            return null;
        }
        catch (TimeoutException e) {
            throw new AssertionError((Object)("Given future did not complete in time: " + future));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertByteBufContains(ByteBuf buf, Number ... values) {
        try {
            Assertions.assertNotNull((Object)buf);
            int expectedReadableBytes = 0;
            for (Number value : values) {
                expectedReadableBytes += TestUtil.bytesCount(value);
            }
            Assertions.assertEquals((int)expectedReadableBytes, (int)buf.readableBytes(), (String)"Unexpected number of bytes");
            for (Number expectedValue : values) {
                Number actualValue = TestUtil.read(buf, expectedValue.getClass());
                String valueType = actualValue.getClass().getSimpleName();
                Assertions.assertEquals((Object)expectedValue, (Object)actualValue, (String)(valueType + " values not equal"));
            }
        }
        finally {
            TestUtil.releaseIfPossible(buf);
        }
    }

    public static void assertByteBufEquals(ByteBuf expected, ByteBuf actual) {
        try {
            Assertions.assertEquals((Object)expected, (Object)actual);
        }
        finally {
            TestUtil.releaseIfPossible(expected);
            TestUtil.releaseIfPossible(actual);
        }
    }

    @SafeVarargs
    public static <T> Set<T> asOrderedSet(T ... elements) {
        return new LinkedHashSet<T>(Arrays.asList(elements));
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... elements) {
        return new HashSet<T>(Arrays.asList(elements));
    }

    public static long countNodes(Driver driver, Bookmark bookmark) {
        try (Session session = driver.session(SessionConfig.builder().withBookmarks(new Bookmark[]{bookmark}).build());){
            long l = (Long)session.readTransaction(tx -> tx.run("MATCH (n) RETURN count(n)").single().get(0).asLong());
            return l;
        }
    }

    public static Bookmark cleanDb(Driver driver) {
        try (Session session = driver.session();){
            TestUtil.cleanDb(session);
            Bookmark bookmark = session.lastBookmark();
            return bookmark;
        }
    }

    public static void dropDatabase(Driver driver, String database) {
        boolean databaseExists = TestUtil.databaseExists(driver, database);
        if (!databaseExists) {
            return;
        }
        try (Session session = driver.session(SessionConfig.forDatabase((String)"system"));){
            session.run("DROP DATABASE " + database).consume();
        }
    }

    public static void createDatabase(Driver driver, String database) {
        boolean databaseExists = TestUtil.databaseExists(driver, database);
        if (databaseExists) {
            return;
        }
        try (Session session = driver.session(SessionConfig.forDatabase((String)"system"));){
            session.run("CREATE DATABASE " + database).consume();
        }
    }

    public static boolean databaseExists(Driver driver, String database) {
        try (Session session = driver.session(SessionConfig.forDatabase((String)"system"));){
            boolean bl = session.run("SHOW DATABASES").stream().anyMatch(r -> r.get("name").asString().equals(database));
            return bl;
        }
    }

    public static NetworkSession newSession(ConnectionProvider connectionProvider, Bookmark x) {
        return TestUtil.newSession(connectionProvider, AccessMode.WRITE, x);
    }

    private static NetworkSession newSession(ConnectionProvider connectionProvider, AccessMode mode, Bookmark x) {
        return TestUtil.newSession(connectionProvider, mode, (RetryLogic)new FixedRetryLogic(0), x);
    }

    public static NetworkSession newSession(ConnectionProvider connectionProvider, AccessMode mode) {
        return TestUtil.newSession(connectionProvider, mode, InternalBookmark.empty());
    }

    public static NetworkSession newSession(ConnectionProvider connectionProvider, RetryLogic logic) {
        return TestUtil.newSession(connectionProvider, AccessMode.WRITE, logic, InternalBookmark.empty());
    }

    public static NetworkSession newSession(ConnectionProvider connectionProvider) {
        return TestUtil.newSession(connectionProvider, AccessMode.WRITE, InternalBookmark.empty());
    }

    public static NetworkSession newSession(ConnectionProvider connectionProvider, AccessMode mode, RetryLogic retryLogic, Bookmark bookmark) {
        return new NetworkSession(connectionProvider, retryLogic, DatabaseNameUtil.defaultDatabase(), mode, (BookmarkHolder)new DefaultBookmarkHolder(bookmark), null, -1L, DevNullLogging.DEV_NULL_LOGGING);
    }

    public static void verifyRunRx(Connection connection, String query) {
        ((Connection)Mockito.verify((Object)connection)).writeAndFlush((Message)ArgumentMatchers.argThat(TestUtil.runWithMetaMessageWithQueryMatcher(query)), (ResponseHandler)ArgumentMatchers.any());
    }

    public static void verifyRunAndPull(Connection connection, String query) {
        ((Connection)Mockito.verify((Object)connection)).write((Message)ArgumentMatchers.argThat(TestUtil.runWithMetaMessageWithQueryMatcher(query)), (ResponseHandler)ArgumentMatchers.any());
        ((Connection)Mockito.verify((Object)connection)).writeAndFlush((Message)ArgumentMatchers.any(PullMessage.class), (ResponseHandler)ArgumentMatchers.any());
    }

    public static void verifyCommitTx(Connection connection, VerificationMode mode) {
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)mode)).writeAndFlush((Message)ArgumentMatchers.any(CommitMessage.class), (ResponseHandler)ArgumentMatchers.any());
    }

    public static void verifyCommitTx(Connection connection) {
        TestUtil.verifyCommitTx(connection, Mockito.times((int)1));
    }

    public static void verifyRollbackTx(Connection connection, VerificationMode mode) {
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)mode)).writeAndFlush((Message)ArgumentMatchers.any(RollbackMessage.class), (ResponseHandler)ArgumentMatchers.any());
    }

    public static void verifyRollbackTx(Connection connection) {
        TestUtil.verifyRollbackTx(connection, Mockito.times((int)1));
    }

    public static void verifyBeginTx(Connection connectionMock) {
        TestUtil.verifyBeginTx(connectionMock, 1);
    }

    public static void verifyBeginTx(Connection connectionMock, int times) {
        ((Connection)Mockito.verify((Object)connectionMock, (VerificationMode)Mockito.times((int)times))).writeAndFlush((Message)ArgumentMatchers.any(BeginMessage.class), (ResponseHandler)ArgumentMatchers.any(BeginTxResponseHandler.class));
    }

    public static void setupFailingRun(Connection connection, Throwable error) {
        ((Connection)Mockito.doAnswer(invocation -> {
            ResponseHandler runHandler = (ResponseHandler)invocation.getArgument(1);
            runHandler.onFailure(error);
            return null;
        }).when((Object)connection)).write((Message)ArgumentMatchers.any(RunWithMetadataMessage.class), (ResponseHandler)ArgumentMatchers.any());
        ((Connection)Mockito.doAnswer(invocation -> {
            ResponseHandler pullHandler = (ResponseHandler)invocation.getArgument(1);
            pullHandler.onFailure(error);
            return null;
        }).when((Object)connection)).writeAndFlush((Message)ArgumentMatchers.any(PullMessage.class), (ResponseHandler)ArgumentMatchers.any());
    }

    public static void setupFailingBegin(Connection connection, Throwable error) {
        ((Connection)Mockito.doAnswer(invocation -> {
            ResponseHandler handler = (ResponseHandler)invocation.getArgument(1);
            handler.onFailure(error);
            return null;
        }).when((Object)connection)).writeAndFlush((Message)ArgumentMatchers.any(BeginMessage.class), (ResponseHandler)ArgumentMatchers.any(BeginTxResponseHandler.class));
    }

    public static void setupFailingCommit(Connection connection) {
        TestUtil.setupFailingCommit(connection, 1);
    }

    public static void setupFailingCommit(Connection connection, final int times) {
        ((Connection)Mockito.doAnswer((Answer)new Answer<Void>(){
            int invoked;

            public Void answer(InvocationOnMock invocation) {
                ResponseHandler handler = (ResponseHandler)invocation.getArgument(1);
                if (this.invoked++ < times) {
                    handler.onFailure((Throwable)new ServiceUnavailableException(""));
                } else {
                    handler.onSuccess(Collections.emptyMap());
                }
                return null;
            }
        }).when((Object)connection)).writeAndFlush((Message)ArgumentMatchers.any(CommitMessage.class), (ResponseHandler)ArgumentMatchers.any());
    }

    public static void setupFailingRollback(Connection connection) {
        TestUtil.setupFailingRollback(connection, 1);
    }

    public static void setupFailingRollback(Connection connection, final int times) {
        ((Connection)Mockito.doAnswer((Answer)new Answer<Void>(){
            int invoked;

            public Void answer(InvocationOnMock invocation) {
                ResponseHandler handler = (ResponseHandler)invocation.getArgument(1);
                if (this.invoked++ < times) {
                    handler.onFailure((Throwable)new ServiceUnavailableException(""));
                } else {
                    handler.onSuccess(Collections.emptyMap());
                }
                return null;
            }
        }).when((Object)connection)).writeAndFlush((Message)ArgumentMatchers.any(RollbackMessage.class), (ResponseHandler)ArgumentMatchers.any());
    }

    public static void setupSuccessfulRunAndPull(Connection connection) {
        ((Connection)Mockito.doAnswer(invocation -> {
            ResponseHandler runHandler = (ResponseHandler)invocation.getArgument(1);
            runHandler.onSuccess(Collections.emptyMap());
            return null;
        }).when((Object)connection)).write((Message)ArgumentMatchers.any(RunWithMetadataMessage.class), (ResponseHandler)ArgumentMatchers.any());
        ((Connection)Mockito.doAnswer(invocation -> {
            ResponseHandler pullHandler = (ResponseHandler)invocation.getArgument(1);
            pullHandler.onSuccess(Collections.emptyMap());
            return null;
        }).when((Object)connection)).writeAndFlush((Message)ArgumentMatchers.any(PullMessage.class), (ResponseHandler)ArgumentMatchers.any());
    }

    public static void setupSuccessfulRunRx(Connection connection) {
        ((Connection)Mockito.doAnswer(invocation -> {
            ResponseHandler runHandler = (ResponseHandler)invocation.getArgument(1);
            runHandler.onSuccess(Collections.emptyMap());
            return null;
        }).when((Object)connection)).writeAndFlush((Message)ArgumentMatchers.any(RunWithMetadataMessage.class), (ResponseHandler)ArgumentMatchers.any());
    }

    public static void setupSuccessfulRunAndPull(Connection connection, String query) {
        ((Connection)Mockito.doAnswer(invocation -> {
            ResponseHandler runHandler = (ResponseHandler)invocation.getArgument(1);
            runHandler.onSuccess(Collections.emptyMap());
            return null;
        }).when((Object)connection)).write((Message)ArgumentMatchers.argThat(TestUtil.runWithMetaMessageWithQueryMatcher(query)), (ResponseHandler)ArgumentMatchers.any());
        ((Connection)Mockito.doAnswer(invocation -> {
            ResponseHandler pullHandler = (ResponseHandler)invocation.getArgument(1);
            pullHandler.onSuccess(Collections.emptyMap());
            return null;
        }).when((Object)connection)).writeAndFlush((Message)ArgumentMatchers.any(PullMessage.class), (ResponseHandler)ArgumentMatchers.any());
    }

    public static Connection connectionMock() {
        return TestUtil.connectionMock(BoltProtocolV42.INSTANCE);
    }

    public static Connection connectionMock(BoltProtocol protocol) {
        return TestUtil.connectionMock(AccessMode.WRITE, protocol);
    }

    public static Connection connectionMock(AccessMode mode, BoltProtocol protocol) {
        return TestUtil.connectionMock(null, mode, protocol);
    }

    public static Connection connectionMock(String databaseName, BoltProtocol protocol) {
        return TestUtil.connectionMock(databaseName, AccessMode.WRITE, protocol);
    }

    public static Connection connectionMock(String databaseName, AccessMode mode, BoltProtocol protocol) {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection.serverAddress()).thenReturn((Object)BoltServerAddress.LOCAL_DEFAULT);
        Mockito.when((Object)connection.serverVersion()).thenReturn((Object)ServerVersion.vInDev);
        Mockito.when((Object)connection.protocol()).thenReturn((Object)protocol);
        Mockito.when((Object)connection.mode()).thenReturn((Object)mode);
        Mockito.when((Object)connection.databaseName()).thenReturn((Object)DatabaseNameUtil.database((String)databaseName));
        BoltProtocolVersion version = protocol.version();
        if (!(version.equals((Object)BoltProtocolV3.VERSION) || version.equals((Object)BoltProtocolV4.VERSION) || version.equals((Object)BoltProtocolV41.VERSION) || version.equals((Object)BoltProtocolV42.VERSION) || version.equals((Object)BoltProtocolV43.VERSION) || version.equals((Object)BoltProtocolV44.VERSION))) {
            throw new IllegalArgumentException("Unsupported bolt protocol version: " + version);
        }
        TestUtil.setupSuccessResponse(connection, CommitMessage.class);
        TestUtil.setupSuccessResponse(connection, RollbackMessage.class);
        TestUtil.setupSuccessResponse(connection, BeginMessage.class);
        Mockito.when((Object)connection.release()).thenReturn((Object)Futures.completedWithNull());
        Mockito.when((Object)connection.reset()).thenReturn((Object)Futures.completedWithNull());
        return connection;
    }

    public static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public static void interruptWhenInWaitingState(Thread thread) {
        CompletableFuture.runAsync(() -> {
            do {
                TestUtil.sleep(500);
            } while (thread.getState() != Thread.State.WAITING);
            thread.interrupt();
        });
    }

    public static int activeQueryCount(Driver driver) {
        return TestUtil.activeQueryNames(driver).size();
    }

    public static List<String> activeQueryNames(Driver driver) {
        try (Session session = driver.session();){
            List<String> list = session.run("CALL dbms.listQueries() YIELD query RETURN query").list().stream().map(record -> record.get(0).asString()).filter(query -> !query.contains("dbms.listQueries")).collect(Collectors.toList());
            return list;
        }
    }

    public static void awaitCondition(BooleanSupplier condition) {
        TestUtil.awaitCondition(condition, DEFAULT_WAIT_TIME_MS, TimeUnit.MILLISECONDS);
    }

    public static void awaitCondition(BooleanSupplier condition, long value, TimeUnit unit) {
        long deadline = System.currentTimeMillis() + unit.toMillis(value);
        while (!condition.getAsBoolean()) {
            if (System.currentTimeMillis() > deadline) {
                Assertions.fail((String)"Condition was not met in time");
            }
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Assertions.fail((String)"Interrupted while waiting");
            }
        }
    }

    public static String randomString(int size) {
        StringBuilder sb = new StringBuilder(size);
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < size; ++i) {
            sb.append(ALPHANUMERICS.charAt(random.nextInt(ALPHANUMERICS.length())));
        }
        return sb.toString();
    }

    public static ArgumentMatcher<Message> runWithMetaMessageWithQueryMatcher(String query) {
        return message -> message instanceof RunWithMetadataMessage && Objects.equals(query, ((RunWithMetadataMessage)message).query());
    }

    public static ArgumentMatcher<Message> beginMessage() {
        return TestUtil.beginMessageWithPredicate(ignored -> true);
    }

    public static ArgumentMatcher<Message> beginMessageWithPredicate(Predicate<BeginMessage> predicate) {
        return message -> message instanceof BeginMessage && predicate.test((BeginMessage)message);
    }

    public static ServerVersion anyServerVersion() {
        return ServerVersion.v4_0_0;
    }

    public static void assertNoCircularReferences(Throwable ex) {
        TestUtil.assertNoCircularReferences(ex, new ArrayList<Throwable>());
    }

    private static void assertNoCircularReferences(Throwable ex, List<Throwable> list) {
        list.add(ex);
        if (ex.getCause() != null) {
            if (list.contains(ex.getCause())) {
                throw new AssertionError("Circular reference detected", ex.getCause());
            }
            TestUtil.assertNoCircularReferences(ex.getCause(), list);
        }
        for (Throwable suppressed : ex.getSuppressed()) {
            if (list.contains(suppressed)) {
                throw new AssertionError("Circular reference detected", suppressed);
            }
            TestUtil.assertNoCircularReferences(suppressed, list);
        }
    }

    private static void setupSuccessResponse(Connection connection, Class<? extends Message> messageType) {
        ((Connection)Mockito.doAnswer(invocation -> {
            ResponseHandler handler = (ResponseHandler)invocation.getArgument(1);
            handler.onSuccess(Collections.emptyMap());
            return null;
        }).when((Object)connection)).writeAndFlush((Message)ArgumentMatchers.any(messageType), (ResponseHandler)ArgumentMatchers.any());
    }

    private static void cleanDb(Session session) {
        int nodesDeleted;
        while ((nodesDeleted = TestUtil.deleteBatchOfNodes(session)) > 0) {
        }
    }

    private static int deleteBatchOfNodes(Session session) {
        return (Integer)session.writeTransaction(tx -> {
            Result result = tx.run("MATCH (n) WITH n LIMIT 1000 DETACH DELETE n RETURN count(n)");
            return result.single().get(0).asInt();
        });
    }

    private static Number read(ByteBuf buf, Class<? extends Number> type) {
        if (type == Byte.class) {
            return buf.readByte();
        }
        if (type == Short.class) {
            return buf.readShort();
        }
        if (type == Integer.class) {
            return buf.readInt();
        }
        if (type == Long.class) {
            return buf.readLong();
        }
        if (type == Float.class) {
            return Float.valueOf(buf.readFloat());
        }
        if (type == Double.class) {
            return buf.readDouble();
        }
        throw new IllegalArgumentException("Unexpected numeric type: " + type);
    }

    private static int bytesCount(Number value) {
        if (value instanceof Byte) {
            return 1;
        }
        if (value instanceof Short) {
            return 2;
        }
        if (value instanceof Integer) {
            return 4;
        }
        if (value instanceof Long) {
            return 8;
        }
        if (value instanceof Float) {
            return 4;
        }
        if (value instanceof Double) {
            return 8;
        }
        throw new IllegalArgumentException("Unexpected number: '" + value + "' or type" + value.getClass());
    }

    private static void releaseIfPossible(ByteBuf buf) {
        if (buf.refCnt() > 0) {
            buf.release();
        }
    }

    public static <T extends Serializable> T serializeAndReadBack(T instance, Class<T> targetClass) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (Closeable oos = new ObjectOutputStream(bos);){
            ((ObjectOutputStream)oos).writeObject(instance);
        }
        bos.close();
        oos = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        try {
            Serializable serializable = (Serializable)targetClass.cast(((ObjectInputStream)oos).readObject());
            return (T)serializable;
        }
        finally {
            ((ObjectInputStream)oos).close();
        }
    }
}

