/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.util.cc;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Scanner;
import org.neo4j.driver.internal.BoltServerAddress;

public class ClusterMember {
    public static final String SIMPLE_SCHEME = "bolt://";
    public static final String ROUTING_SCHEME = "neo4j://";
    private final URI boltUri;
    private final BoltServerAddress boltAddress;
    private final Path path;

    public ClusterMember(URI boltUri, Path path) {
        this.boltUri = Objects.requireNonNull(boltUri);
        this.boltAddress = ClusterMember.newBoltServerAddress(boltUri);
        this.path = Objects.requireNonNull(path);
    }

    public URI getBoltUri() {
        return this.boltUri;
    }

    public URI getRoutingUri() {
        return URI.create(this.boltUri.toString().replace(SIMPLE_SCHEME, ROUTING_SCHEME));
    }

    public BoltServerAddress getBoltAddress() {
        return this.boltAddress;
    }

    public Path getPath() {
        return this.path;
    }

    public void dumpDebugLog() throws FileNotFoundException {
        Scanner input = new Scanner(new File(this.path.toAbsolutePath().toString() + "/logs/debug.log"));
        while (input.hasNextLine()) {
            System.out.println(input.nextLine());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterMember that = (ClusterMember)o;
        return Objects.equals(this.boltAddress, that.boltAddress);
    }

    public int hashCode() {
        return Objects.hash(this.boltAddress);
    }

    public String toString() {
        return "ClusterMember{boltUri=" + this.boltUri + ", boltAddress=" + this.boltAddress + ", path=" + this.path + '}';
    }

    private static BoltServerAddress newBoltServerAddress(URI uri) {
        try {
            return new BoltServerAddress(InetAddress.getByName(uri.getHost()).getHostAddress(), uri.getPort());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }
}

