/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakBag<T>
implements Iterable<T> {
    private final List<MyRef> _refs = new LinkedList<MyRef>();

    public void add(T t) {
        this._refs.add(new MyRef(t));
    }

    public boolean remove(T t) {
        Iterator<MyRef> i = this._refs.iterator();
        while (i.hasNext()) {
            MyRef ref = i.next();
            if (ref == null) continue;
            Object me = ref.get();
            if (me == null) {
                i.remove();
                continue;
            }
            if (me != t) continue;
            i.remove();
            return true;
        }
        return false;
    }

    public boolean contains(T t) {
        for (MyRef ref : this._refs) {
            Object me = ref.get();
            if (me != t) continue;
            return true;
        }
        return false;
    }

    public int size() {
        this.clean();
        return this._refs.size();
    }

    public void clear() {
        this._refs.clear();
    }

    public void clean() {
        Iterator<MyRef> i = this._refs.iterator();
        while (i.hasNext()) {
            MyRef ref = i.next();
            if (ref.get() != null) continue;
            i.remove();
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.getAll().iterator();
    }

    public List<T> getAll() {
        ArrayList l = new ArrayList();
        Iterator<MyRef> i = this._refs.iterator();
        while (i.hasNext()) {
            MyRef ref = i.next();
            Object t = ref.get();
            if (t == null) {
                i.remove();
                continue;
            }
            l.add(t);
        }
        return l;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyRef
    extends WeakReference<T> {
        MyRef(T t) {
            super(t);
        }
    }
}

