/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.connection.ClusterId;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ClusterableServer;
import com.mongodb.connection.ClusterableServerFactory;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.DefaultConnectionFactory;
import com.mongodb.connection.DefaultConnectionPool;
import com.mongodb.connection.DefaultServer;
import com.mongodb.connection.DefaultServerMonitorFactory;
import com.mongodb.connection.InternalStreamConnectionFactory;
import com.mongodb.connection.ServerId;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.StreamFactory;
import com.mongodb.event.ConnectionListener;
import com.mongodb.event.ConnectionPoolListener;
import java.util.List;

class DefaultClusterableServerFactory
implements ClusterableServerFactory {
    private final ClusterId clusterId;
    private final ClusterSettings clusterSettings;
    private final ServerSettings settings;
    private final ConnectionPoolSettings connectionPoolSettings;
    private final StreamFactory streamFactory;
    private final List<MongoCredential> credentialList;
    private final ConnectionPoolListener connectionPoolListener;
    private final ConnectionListener connectionListener;
    private final StreamFactory heartbeatStreamFactory;

    public DefaultClusterableServerFactory(ClusterId clusterId, ClusterSettings clusterSettings, ServerSettings settings, ConnectionPoolSettings connectionPoolSettings, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory, List<MongoCredential> credentialList, ConnectionListener connectionListener, ConnectionPoolListener connectionPoolListener) {
        this.clusterId = clusterId;
        this.clusterSettings = clusterSettings;
        this.settings = settings;
        this.connectionPoolSettings = connectionPoolSettings;
        this.streamFactory = streamFactory;
        this.credentialList = credentialList;
        this.connectionPoolListener = connectionPoolListener;
        this.connectionListener = connectionListener;
        this.heartbeatStreamFactory = heartbeatStreamFactory;
    }

    @Override
    public ClusterableServer create(ServerAddress serverAddress) {
        DefaultConnectionPool connectionPool = new DefaultConnectionPool(new ServerId(this.clusterId, serverAddress), new InternalStreamConnectionFactory(this.streamFactory, this.credentialList, this.connectionListener), this.connectionPoolSettings, this.connectionPoolListener);
        DefaultServerMonitorFactory serverMonitorFactory = new DefaultServerMonitorFactory(new ServerId(this.clusterId, serverAddress), this.settings, new InternalStreamConnectionFactory(this.heartbeatStreamFactory, this.credentialList, this.connectionListener), connectionPool);
        return new DefaultServer(serverAddress, this.clusterSettings.getMode(), connectionPool, new DefaultConnectionFactory(), serverMonitorFactory);
    }

    @Override
    public ServerSettings getSettings() {
        return this.settings;
    }
}

