/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.Function;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncConnectionSource;
import com.mongodb.binding.ConnectionSource;
import com.mongodb.connection.QueryResult;
import com.mongodb.operation.AsyncQueryBatchCursor;
import com.mongodb.operation.QueryBatchCursor;
import java.util.ArrayList;
import java.util.List;
import org.bson.codecs.Decoder;

final class FindOperationHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T, V> List<V> queryResultToList(QueryResult<T> queryResult, Decoder<T> decoder, ConnectionSource source, Function<T, V> block) {
        QueryBatchCursor<T> cursor = new QueryBatchCursor<T>(queryResult, 0, 0, decoder, source);
        try {
            ArrayList<V> retVal = new ArrayList<V>();
            while (cursor.hasNext()) {
                for (Object cur : cursor.next()) {
                    V value = block.apply(cur);
                    if (value == null) continue;
                    retVal.add(value);
                }
            }
            ArrayList<V> arrayList = retVal;
            return arrayList;
        }
        finally {
            cursor.close();
        }
    }

    static <T, V> void queryResultToListAsync(QueryResult<T> queryResult, Decoder<T> decoder, AsyncConnectionSource source, Function<T, V> transformer, SingleResultCallback<List<V>> callback) {
        new QueryResultToListCallback<T, V>(decoder, source, transformer, callback).onResult(queryResult, (Throwable)null);
    }

    private FindOperationHelper() {
    }

    private static class QueryResultToListCallback<T, V>
    implements SingleResultCallback<QueryResult<T>> {
        private final Decoder<T> decoder;
        private final AsyncConnectionSource connectionSource;
        private final Function<T, V> mapper;
        private final SingleResultCallback<List<V>> callback;

        public QueryResultToListCallback(Decoder<T> decoder, AsyncConnectionSource connectionSource, Function<T, V> mapper, SingleResultCallback<List<V>> callback) {
            this.decoder = decoder;
            this.connectionSource = connectionSource;
            this.mapper = mapper;
            this.callback = callback;
        }

        @Override
        public void onResult(QueryResult<T> results, Throwable t) {
            if (t != null) {
                this.callback.onResult(null, t);
            } else {
                this.loopCursor(new AsyncQueryBatchCursor<T>(results, 0, 0, this.decoder, this.connectionSource), new ArrayList());
            }
        }

        private void loopCursor(final AsyncBatchCursor<T> batchCursor, final List<V> mappedResults) {
            batchCursor.next(new SingleResultCallback<List<T>>(){

                @Override
                public void onResult(List<T> results, Throwable t) {
                    if (t != null || results == null) {
                        batchCursor.close();
                        QueryResultToListCallback.this.callback.onResult(mappedResults, t);
                    } else {
                        try {
                            for (Object result : results) {
                                Object mappedResult = QueryResultToListCallback.this.mapper.apply(result);
                                if (mappedResult == null) continue;
                                mappedResults.add(mappedResult);
                            }
                            QueryResultToListCallback.this.loopCursor(batchCursor, mappedResults);
                        }
                        catch (Throwable tr) {
                            batchCursor.close();
                            QueryResultToListCallback.this.callback.onResult(null, tr);
                        }
                    }
                }
            });
        }
    }
}

