/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.javamodelchecker;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.ToolProvider;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.javamodelchecker.CompileException;
import org.bimserver.javamodelchecker.JavaModelCheckerInterface;
import org.bimserver.models.store.ModelCheckerResult;
import org.bimserver.plugins.VirtualClassLoader;
import org.bimserver.plugins.VirtualFile;
import org.bimserver.plugins.VirtualFileManager;
import org.bimserver.plugins.modelchecker.ModelCheckException;
import org.bimserver.plugins.modelchecker.ModelChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaModelChecker
implements ModelChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaModelChecker.class);
    private static String libPath = System.getProperty("java.class.path");
    private ClassLoader classLoader;
    private JavaFileManager pluginFileManager;

    public JavaModelChecker(ClassLoader classLoader, Path rootPath) {
        this.classLoader = classLoader;
        this.pluginFileManager = ToolProvider.getSystemJavaCompiler().getStandardFileManager(null, null, null);
    }

    public ModelCheckerResult check(IfcModelInterface model, byte[] compiledCode) throws ModelCheckException {
        try {
            VirtualFile baseDir = VirtualFile.fromJar((InputStream)new ByteArrayInputStream(compiledCode));
            VirtualClassLoader loader = new VirtualClassLoader(this.classLoader, baseDir);
            try {
                Class loadClass = loader.loadClass("org.bimserver.javamodelchecker.Implementation");
                JavaModelCheckerInterface modelCheckerInterface = (JavaModelCheckerInterface)loadClass.newInstance();
                ModelCheckerResult modelCheckerResult = modelCheckerInterface.check(model);
                return modelCheckerResult;
            }
            catch (Exception e) {
                throw new CompileException(e);
            }
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    public static void addJarFolder(File libDir) {
        if (libDir.exists() && libDir.isDirectory()) {
            for (File file : libDir.listFiles()) {
                if (!file.getName().endsWith(".jar")) continue;
                libPath = libPath + file.getAbsolutePath() + File.pathSeparator;
            }
        }
        LOGGER.debug("libPath: " + libPath);
    }

    private void getJavaFiles(List<VirtualFile> fileList, VirtualFile baseDir) {
        for (VirtualFile f : baseDir.listFiles()) {
            if (f.isDirectory()) {
                this.getJavaFiles(fileList, f);
                continue;
            }
            if (!f.getName().endsWith(".java")) continue;
            fileList.add(f);
        }
    }

    public byte[] compile(String code) throws ModelCheckException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            throw new ModelCheckException("JDK needed for compile tasks");
        }
        VirtualFile baseDir = new VirtualFile();
        VirtualFile file = baseDir.createFile("org" + File.separator + "bimserver" + File.separator + "javamodelchecker" + File.separator + "Implementation.java");
        file.setStringContent(code);
        VirtualFileManager myFileManager = new VirtualFileManager(this.pluginFileManager, this.classLoader, baseDir);
        ArrayList<VirtualFile> fileList = new ArrayList<VirtualFile>();
        this.getJavaFiles(fileList, baseDir);
        List compilationUnits = baseDir.getAllJavaFileObjects();
        ArrayList<String> options = new ArrayList<String>();
        options.add("-cp");
        options.add(libPath);
        DiagnosticCollector diagnosticsCollector = new DiagnosticCollector();
        compiler.getTask(null, (JavaFileManager)myFileManager, diagnosticsCollector, options, null, compilationUnits).call();
        List diagnostics = diagnosticsCollector.getDiagnostics();
        for (Diagnostic d : diagnostics) {
            if (d.getKind() == Diagnostic.Kind.ERROR) {
                throw new ModelCheckException(d.getMessage(Locale.ENGLISH));
            }
            if (d.getKind() != Diagnostic.Kind.WARNING) continue;
            throw new ModelCheckException(d.getMessage(Locale.ENGLISH));
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        baseDir.createJar((OutputStream)outputStream);
        return outputStream.toByteArray();
    }
}

