/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.pdex;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import processing.app.Messages;
import processing.app.Mode;
import processing.app.SketchCode;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.SyntaxDocument;
import processing.app.syntax.TextAreaDefaults;
import processing.app.syntax.TextAreaPainter;
import processing.app.syntax.TokenMarker;
import processing.app.ui.Editor;
import processing.mode.java.JavaEditor;
import processing.mode.java.pdex.JavaTextArea;
import processing.mode.java.pdex.Problem;
import processing.mode.java.tweak.ColorControlBox;
import processing.mode.java.tweak.ColorSelector;
import processing.mode.java.tweak.Handle;
import processing.mode.java.tweak.Settings;

public class JavaTextAreaPainter
extends TextAreaPainter
implements MouseListener,
MouseMotionListener {
    public Color errorUnderlineColor;
    public Color warningUnderlineColor;
    protected Font gutterTextFont;
    protected Color gutterTextColor;
    protected Color gutterLineHighlightColor;
    protected int horizontalAdjustment = 0;
    public boolean tweakMode = false;
    public List<List<Handle>> handles;
    public List<List<ColorControlBox>> colorBoxes;
    public Handle mouseHandle = null;
    public ColorSelector colorSelector;
    int cursorType;
    BufferedImage cursorImg = new BufferedImage(16, 16, 2);
    Cursor blankCursor;

    public JavaTextAreaPainter(JavaTextArea textArea, TextAreaDefaults defaults) {
        super((JEditTextArea)textArea, defaults);
        Dimension cursorSize = Toolkit.getDefaultToolkit().getBestCursorSize(16, 16);
        this.blankCursor = cursorSize.width == 0 || cursorSize.height == 0 ? Cursor.getDefaultCursor() : Toolkit.getDefaultToolkit().createCustomCursor(this.cursorImg, new Point(0, 0), "blank cursor");
        this.addMouseListener(new MouseAdapter(){
            long lastTime;

            @Override
            public void mousePressed(MouseEvent event) {
                long thisTime;
                JavaEditor javaEditor = JavaTextAreaPainter.this.getJavaEditor();
                if (javaEditor.isDebuggerEnabled() && (thisTime = event.getWhen()) - this.lastTime > 100L) {
                    int offset;
                    if (event.getX() < 44 && (offset = JavaTextAreaPainter.this.getJavaTextArea().xyToOffset(event.getX(), event.getY())) >= 0) {
                        int lineIndex = JavaTextAreaPainter.this.getJavaTextArea().getLineOfOffset(offset);
                        javaEditor.toggleBreakpoint(lineIndex);
                    }
                    this.lastTime = thisTime;
                }
            }
        });
        this.tweakMode = false;
        this.cursorType = 0;
    }

    protected void paintLine(Graphics gfx, int line, int x, TokenMarker tokenMarker) {
        try {
            super.paintLine(gfx, line, x + 44, tokenMarker);
        }
        catch (Exception e) {
            Messages.log((String)e.getMessage());
        }
        this.paintLeftGutter(gfx, line, x);
        this.paintErrorLine(gfx, line, x);
    }

    protected void paintLeftGutter(Graphics gfx, int line, int x) {
        int y = this.textArea.lineToY(line) + this.fm.getLeading() + this.fm.getMaxDescent();
        if (line == this.textArea.getSelectionStopLine()) {
            gfx.setColor(this.gutterLineHighlightColor);
            gfx.fillRect(0, y, 44, this.fm.getHeight());
        } else {
            gfx.setClip(0, y, 44, this.fm.getHeight());
            gfx.drawImage(this.getJavaTextArea().getGutterGradient(), 0, 0, this.getWidth(), this.getHeight(), (ImageObserver)((Object)this));
            gfx.setClip(null);
        }
        String text = null;
        if (this.getJavaEditor().isDebuggerEnabled()) {
            text = this.getJavaTextArea().getGutterText(line);
        }
        gfx.setColor(this.gutterTextColor);
        int textRight = 41;
        int textBaseline = this.textArea.lineToY(line) + this.fm.getHeight();
        if (text != null) {
            if (text.equals("<>")) {
                this.drawDiamond(gfx, textRight - 8, textBaseline - 8, 8.0f, 8.0f);
            } else if (text.equals("->")) {
                this.drawRightArrow(gfx, textRight - 7, (float)textBaseline - 7.5f, 7.0f, 7.0f);
            }
        } else {
            text = String.valueOf(line + 1);
            gfx.setFont(this.gutterTextFont);
            char[] txt = text.toCharArray();
            int tx = textRight - gfx.getFontMetrics().charsWidth(txt, 0, txt.length);
            Utilities.drawTabbedText(new Segment(txt, 0, text.length()), tx, textBaseline, gfx, (TabExpander)((Object)this), 0);
        }
    }

    private void drawDiamond(Graphics g, float x, float y, float w, float h) {
        Graphics2D g2 = (Graphics2D)g;
        GeneralPath path = new GeneralPath();
        path.moveTo(x + w / 2.0f, y);
        path.lineTo(x + w, y + h / 2.0f);
        path.lineTo(x + w / 2.0f, y + h);
        path.lineTo(x, y + h / 2.0f);
        path.closePath();
        g2.fill(path);
    }

    private void drawRightArrow(Graphics g, float x, float y, float w, float h) {
        Graphics2D g2 = (Graphics2D)g;
        GeneralPath path = new GeneralPath();
        path.moveTo(x, y);
        path.lineTo(x + w, y + h / 2.0f);
        path.lineTo(x, y + h);
        path.closePath();
        g2.fill(path);
    }

    private static String trimRight(String str) {
        int i;
        for (i = str.length() - 1; i >= 0 && Character.isWhitespace(str.charAt(i)); --i) {
        }
        return str.substring(0, i + 1);
    }

    protected void paintErrorLine(Graphics gfx, int line, int x) {
        List<Problem> problems = this.getJavaEditor().findProblems(line);
        for (Problem problem : problems) {
            int startOffset = problem.getStartOffset();
            int stopOffset = problem.getStopOffset();
            int lineOffset = this.textArea.getLineStartOffset(line);
            int wiggleStart = Math.max(startOffset, lineOffset);
            int wiggleStop = Math.min(stopOffset, this.textArea.getLineStopOffset(line));
            int y = this.textArea.lineToY(line) + this.fm.getLeading() + this.fm.getMaxDescent();
            try {
                int x2;
                int x1;
                String badCode = null;
                String goodCode = null;
                try {
                    SyntaxDocument doc = this.textArea.getDocument();
                    badCode = doc.getText(wiggleStart, wiggleStop - wiggleStart);
                    goodCode = doc.getText(lineOffset, wiggleStart - lineOffset);
                }
                catch (BadLocationException bl) {
                    return;
                }
                int trimmedLength = badCode.trim().length();
                int rightTrimmedLength = JavaTextAreaPainter.trimRight(badCode).length();
                int leftTrimLength = rightTrimmedLength - trimmedLength;
                if (trimmedLength == 0) {
                    leftTrimLength = 0;
                    rightTrimmedLength = badCode.length();
                }
                if ((x1 = this.textArea.offsetToX(line, goodCode.length() + leftTrimLength)) == (x2 = this.textArea.offsetToX(line, goodCode.length() + rightTrimmedLength))) {
                    x2 += this.fm.stringWidth(" ");
                }
                int y1 = y + this.fm.getHeight() - 2;
                if (line != problem.getLineNumber()) {
                    x1 = 44;
                }
                gfx.setColor(this.errorUnderlineColor);
                if (problem.isWarning()) {
                    gfx.setColor(this.warningUnderlineColor);
                }
                JavaTextAreaPainter.paintSquiggle(gfx, y1, x1, x2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void paintSquiggle(Graphics g, int y, int x1, int x2) {
        for (int xx = x1; xx < x2; xx += 2) {
            g.drawLine(xx, y, xx + 2, y + 1);
            g.drawLine(xx += 2, y + 1, xx + 2, y);
        }
    }

    public void setMode(Mode mode) {
        this.errorUnderlineColor = mode.getColor("editor.error.underline.color");
        this.warningUnderlineColor = mode.getColor("editor.warning.underline.color");
        this.gutterTextFont = mode.getFont("editor.gutter.text.font");
        this.gutterTextColor = mode.getColor("editor.gutter.text.color");
        this.gutterLineHighlightColor = mode.getColor("editor.gutter.linehighlight.color");
    }

    public String getToolTipText(MouseEvent evt) {
        int line = evt.getY() / this.getFontMetrics().getHeight() + this.textArea.getFirstLine();
        if (line >= 0 || line < this.textArea.getLineCount()) {
            List<Problem> problems = this.getJavaEditor().findProblems(line);
            for (Problem problem : problems) {
                int lineStart = this.textArea.getLineStartOffset(line);
                int lineEnd = this.textArea.getLineStopOffset(line);
                int errorStart = problem.getStartOffset();
                int errorEnd = problem.getStopOffset() + 1;
                int startOffset = Math.max(errorStart, lineStart) - lineStart;
                int stopOffset = Math.min(errorEnd, lineEnd) - lineStart;
                int x = evt.getX();
                if (x < this.getJavaTextArea().offsetToX(line, startOffset) || x > this.getJavaTextArea().offsetToX(line, stopOffset)) continue;
                this.getJavaEditor().statusToolTip((JComponent)((Object)this), problem.getMessage(), problem.isError());
                return super.getToolTipText(evt);
            }
        }
        this.setToolTipText(null);
        return super.getToolTipText(evt);
    }

    public synchronized void paint(Graphics gfx) {
        super.paint(gfx);
        if (this.tweakMode && this.handles != null) {
            int y;
            int x;
            int lineStartChar;
            int currentTab = this.getCurrentCodeIndex();
            Graphics2D g2d = (Graphics2D)gfx;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            for (Handle n : this.handles.get(currentTab)) {
                lineStartChar = this.textArea.getLineStartOffset(n.line);
                x = this.textArea.offsetToX(n.line, n.newStartChar - lineStartChar);
                y = this.textArea.lineToY(n.line) + this.fm.getHeight() + 1;
                int end = this.textArea.offsetToX(n.line, n.newEndChar - lineStartChar);
                n.setPos(x, y);
                n.setWidth(end - x);
                n.draw(g2d, n == this.mouseHandle);
            }
            for (ColorControlBox cBox : this.colorBoxes.get(currentTab)) {
                lineStartChar = this.textArea.getLineStartOffset(cBox.getLine());
                x = this.textArea.offsetToX(cBox.getLine(), cBox.getCharIndex() - lineStartChar);
                y = this.textArea.lineToY(cBox.getLine()) + this.fm.getDescent();
                cBox.setPos(x, y + 1);
                cBox.draw(g2d);
            }
        }
    }

    protected void startTweakMode() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.tweakMode = true;
        this.setCursor(new Cursor(0));
        this.repaint();
    }

    protected void stopTweakMode() {
        this.tweakMode = false;
        if (this.colorSelector != null) {
            this.colorSelector.hide();
            WindowEvent windowEvent = new WindowEvent(this.colorSelector.frame, 201);
            this.colorSelector.frame.dispatchEvent(windowEvent);
        }
        this.setCursor(new Cursor(2));
        this.repaint();
    }

    protected void updateInterface(List<List<Handle>> handles, List<List<ColorControlBox>> colorBoxes) {
        this.handles = handles;
        this.colorBoxes = colorBoxes;
        this.initInterfacePositions();
        this.repaint();
    }

    private synchronized void initInterfacePositions() {
        SketchCode[] code = this.getEditor().getSketch().getCode();
        int prevScroll = this.textArea.getVerticalScrollPosition();
        String prevText = this.textArea.getText();
        for (int tab = 0; tab < code.length; ++tab) {
            int x;
            int lineStartChar;
            String tabCode = this.getJavaEditor().baseCode[tab];
            this.textArea.setText(tabCode);
            for (Handle n : this.handles.get(tab)) {
                lineStartChar = this.textArea.getLineStartOffset(n.line);
                x = this.textArea.offsetToX(n.line, n.newStartChar - lineStartChar);
                int end = this.textArea.offsetToX(n.line, n.newEndChar - lineStartChar);
                int y = this.textArea.lineToY(n.line) + this.fm.getHeight() + 1;
                n.initInterface(x, y, end - x, this.fm.getHeight());
            }
            for (ColorControlBox cBox : this.colorBoxes.get(tab)) {
                lineStartChar = this.textArea.getLineStartOffset(cBox.getLine());
                x = this.textArea.offsetToX(cBox.getLine(), cBox.getCharIndex() - lineStartChar);
                int y = this.textArea.lineToY(cBox.getLine()) + this.fm.getDescent();
                cBox.initInterface(this, x, y + 1, this.fm.getHeight() - 2, this.fm.getHeight() - 2);
            }
        }
        this.textArea.setText(prevText);
        this.textArea.scrollTo(prevScroll, 0);
    }

    public void updateCodeText() {
        int charInc = 0;
        int currentTab = this.getCurrentCodeIndex();
        SketchCode sc = this.getEditor().getSketch().getCode(currentTab);
        String code = this.getJavaEditor().baseCode[currentTab];
        for (Handle n : this.handles.get(currentTab)) {
            int s = n.startChar + charInc;
            int e = n.endChar + charInc;
            code = JavaTextAreaPainter.replaceString(code, s, e, n.strNewValue);
            n.newStartChar = n.startChar + charInc;
            n.newEndChar = n.endChar + (charInc += n.strNewValue.length() - n.strValue.length());
        }
        this.replaceTextAreaCode(code);
        sc.setProgram(code);
    }

    private synchronized void replaceTextAreaCode(String code) {
        int scrollLine = this.textArea.getVerticalScrollPosition();
        int scrollHor = this.textArea.getHorizontalScrollPosition();
        this.textArea.setText(code);
        this.textArea.setOrigin(scrollLine, -scrollHor);
    }

    private static String replaceString(String str, int start, int end, String put) {
        return str.substring(0, start) + put + str.substring(end, str.length());
    }

    private void updateCursor(int mouseX, int mouseY) {
        int currentTab = this.getCurrentCodeIndex();
        for (Handle n : this.handles.get(currentTab)) {
            if (!n.pick(mouseX, mouseY)) continue;
            this.cursorType = 10;
            this.setCursor(new Cursor(this.cursorType));
            return;
        }
        for (ColorControlBox colorBox : this.colorBoxes.get(currentTab)) {
            if (!colorBox.pick(mouseX, mouseY)) continue;
            this.cursorType = 12;
            this.setCursor(new Cursor(this.cursorType));
            return;
        }
        if (this.cursorType == 10 || this.cursorType == 12 || this.cursorType == -1) {
            this.cursorType = 0;
            this.setCursor(new Cursor(this.cursorType));
        }
    }

    private void showHideColorBoxes(int y) {
        int currentTab = this.getCurrentCodeIndex();
        boolean change = false;
        for (ColorControlBox box : this.colorBoxes.get(currentTab)) {
            if (!box.setMouseY(y)) continue;
            change = true;
        }
        if (this.colorSelector != null) {
            this.colorSelector.colorBox.visible = true;
        }
        if (change) {
            this.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.mouseHandle != null) {
            this.mouseHandle.setCurrentX(e.getX());
            this.updateCodeText();
            if (this.colorSelector != null) {
                this.colorSelector.refreshColor();
            }
            this.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int currentTab = this.getCurrentCodeIndex();
        for (Handle n : this.handles.get(currentTab)) {
            if (!n.pick(e.getX(), e.getY())) continue;
            this.cursorType = -1;
            this.setCursor(this.blankCursor);
            this.mouseHandle = n;
            this.mouseHandle.setCenterX(e.getX());
            this.repaint();
            return;
        }
        for (ColorControlBox box : this.colorBoxes.get(currentTab)) {
            if (!box.pick(e.getX(), e.getY())) continue;
            if (this.colorSelector != null) {
                this.colorSelector.frame.dispatchEvent(new WindowEvent(this.colorSelector.frame, 201));
            }
            this.colorSelector = new ColorSelector(box);
            this.colorSelector.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    JavaTextAreaPainter.this.colorSelector.frame.setVisible(false);
                    JavaTextAreaPainter.this.colorSelector = null;
                }
            });
            this.colorSelector.show(this.getLocationOnScreen().x + e.getX() + 30, this.getLocationOnScreen().y + e.getY() - 130);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.mouseHandle != null) {
            this.mouseHandle.resetProgress();
            this.mouseHandle = null;
            this.updateCursor(e.getX(), e.getY());
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.updateCursor(e.getX(), e.getY());
        if (!Settings.alwaysShowColorBoxes) {
            this.showHideColorBoxes(e.getY());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    public int getScrollWidth() {
        return super.getWidth() - 44;
    }

    public Editor getEditor() {
        return ((JavaTextArea)this.textArea).editor;
    }

    private JavaEditor getJavaEditor() {
        return ((JavaTextArea)this.textArea).editor;
    }

    private int getCurrentCodeIndex() {
        return this.getEditor().getSketch().getCurrentCodeIndex();
    }

    private JavaTextArea getJavaTextArea() {
        return (JavaTextArea)this.textArea;
    }
}

