/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.pdex;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.BitSet;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.SwingWorker;
import processing.app.Messages;
import processing.app.Mode;
import processing.app.Platform;
import processing.app.syntax.InputHandler;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.TextAreaDefaults;
import processing.mode.java.JavaEditor;
import processing.mode.java.JavaInputHandler;
import processing.mode.java.JavaMode;
import processing.mode.java.pdex.CompletionCandidate;
import processing.mode.java.pdex.CompletionGenerator;
import processing.mode.java.pdex.CompletionPanel;
import processing.mode.java.pdex.JavaTextAreaPainter;
import processing.mode.java.pdex.PreprocessedSketch;
import processing.mode.java.tweak.ColorControlBox;
import processing.mode.java.tweak.Handle;

public class JavaTextArea
extends JEditTextArea {
    protected final JavaEditor editor;
    protected Image gutterGradient;
    public static final String BREAK_MARKER = "<>";
    public static final String STEP_MARKER = "->";
    protected final Map<Integer, String> gutterText = new HashMap<Integer, String>();
    private CompletionPanel suggestion;
    CompletionGenerator suggestionGenerator;
    SwingWorker<Void, Void> suggestionWorker = null;
    volatile boolean suggestionRunning = false;
    volatile boolean suggestionRequested = false;
    protected final MouseMotionAdapter gutterCursorMouseAdapter = new MouseMotionAdapter(){
        private int lastX;

        @Override
        public void mouseMoved(MouseEvent me) {
            if (me.getX() < 44) {
                if (this.lastX >= 44) {
                    JavaTextArea.this.painter.setCursor(new Cursor(0));
                }
            } else if (this.lastX < 44) {
                JavaTextArea.this.painter.setCursor(new Cursor(2));
            }
            this.lastX = me.getX();
        }
    };
    protected final ComponentListener[] prevCompListeners;
    protected final MouseListener[] prevMouseListeners;
    protected final MouseMotionListener[] prevMMotionListeners;
    protected final KeyListener[] prevKeyListeners;
    protected boolean tweakMode;

    public JavaTextArea(TextAreaDefaults defaults, JavaEditor editor) {
        super(defaults, (InputHandler)new JavaInputHandler(editor));
        this.editor = editor;
        this.painter.addMouseMotionListener((MouseMotionListener)this.gutterCursorMouseAdapter);
        this.add(CENTER, (Component)this.painter);
        Mode mode = editor.getMode();
        this.gutterGradient = mode.makeGradient("editor", 44, 500);
        this.prevCompListeners = this.painter.getComponentListeners();
        this.prevMouseListeners = this.painter.getMouseListeners();
        this.prevMMotionListeners = this.painter.getMouseMotionListeners();
        this.prevKeyListeners = editor.getKeyListeners();
        this.suggestionGenerator = new CompletionGenerator();
        this.tweakMode = false;
    }

    protected JavaTextAreaPainter createPainter(TextAreaDefaults defaults) {
        return new JavaTextAreaPainter(this, defaults);
    }

    protected JavaTextAreaPainter getCustomPainter() {
        return (JavaTextAreaPainter)this.painter;
    }

    public void setMode(JavaMode mode) {
        this.getCustomPainter().setMode(mode);
    }

    public void processKeyEvent(KeyEvent evt) {
        if (evt.getKeyCode() == 27) {
            if (this.suggestion != null && this.suggestion.isVisible()) {
                Messages.log((String)"esc key");
                this.hideSuggestion();
                evt.consume();
                return;
            }
        } else if (evt.getKeyCode() == 10 && evt.getID() == 401 && this.suggestion != null && this.suggestion.isVisible() && this.suggestion.insertSelection(20)) {
            evt.consume();
            if (this.suggestion.isVisible()) {
                this.prepareSuggestions(evt);
            }
            return;
        }
        if (evt.getID() == 401) {
            switch (evt.getKeyCode()) {
                case 40: {
                    if (this.suggestion == null || !this.suggestion.isVisible()) break;
                    this.suggestion.moveDown();
                    return;
                }
                case 38: {
                    if (this.suggestion == null || !this.suggestion.isVisible()) break;
                    this.suggestion.moveUp();
                    return;
                }
                case 8: {
                    Messages.log((String)"BK Key");
                    break;
                }
                case 32: {
                    if (this.suggestion == null || !this.suggestion.isVisible()) break;
                    Messages.log((String)"Space bar, hide completion list");
                    this.suggestion.setInvisible();
                }
            }
        }
        super.processKeyEvent(evt);
        if (!this.editor.hasJavaTabs()) {
            if (evt.getID() == 400) {
                this.processCompletionKeys(evt);
            } else if (!Platform.isMacOS() && evt.getID() == 402) {
                this.processCompletionKeys(evt);
            } else if (Platform.isMacOS() && evt.getID() == 402) {
                this.processControlSpace(evt);
            }
        }
    }

    private void processControlSpace(KeyEvent event) {
        if (event.getKeyCode() == 32 && event.isControlDown() && JavaMode.codeCompletionsEnabled) {
            Messages.log((String)("[KeyEvent]" + KeyEvent.getKeyText(event.getKeyCode()) + "  |Prediction started"));
            this.fetchPhrase();
        }
    }

    private void processCompletionKeys(KeyEvent event) {
        char keyChar = event.getKeyChar();
        int keyCode = event.getKeyCode();
        if (keyChar != '\n' && keyChar != '\u001b' && keyChar != '\t' && (event.getID() != 402 || keyCode == 37 || keyCode == 39)) {
            if (keyChar == ')') {
                this.hideSuggestion();
            } else if (keyChar == '.') {
                if (JavaMode.codeCompletionsEnabled) {
                    Messages.log((String)("[KeyEvent]" + KeyEvent.getKeyText(event.getKeyCode()) + "  |Prediction started"));
                    this.fetchPhrase();
                }
            } else if (keyChar == ' ') {
                if (!Platform.isMacOS() && JavaMode.codeCompletionsEnabled && (event.isControlDown() || event.isMetaDown())) {
                    if (JavaMode.codeCompletionsEnabled) {
                        Messages.log((String)("[KeyEvent]" + event.getKeyChar() + "  |Prediction started"));
                        this.fetchPhrase();
                    }
                } else {
                    this.hideSuggestion();
                }
            } else if (JavaMode.codeCompletionsEnabled) {
                this.prepareSuggestions(event);
            }
        }
    }

    private void prepareSuggestions(KeyEvent evt) {
        if (JavaMode.codeCompletionsEnabled && (JavaMode.ccTriggerEnabled || this.suggestion != null && this.suggestion.isVisible())) {
            Messages.log((String)("[KeyEvent]" + evt.getKeyChar() + "  |Prediction started"));
            this.fetchPhrase();
        }
    }

    protected void fetchPhrase() {
        if (this.suggestionRunning) {
            this.suggestionRequested = true;
            return;
        }
        this.suggestionRunning = true;
        this.suggestionRequested = false;
        int caretPosition = this.getCaretPosition();
        if (caretPosition < 0) {
            this.suggestionRunning = false;
            return;
        }
        int caretLineIndex = this.getCaretLine();
        if (caretLineIndex < 0) {
            this.suggestionRunning = false;
            return;
        }
        String lineText = this.getLineText(caretLineIndex);
        if (lineText == null) {
            this.suggestionRunning = false;
            return;
        }
        int caretLinePosition = this.getCaretPosition() - this.getLineStartOffset(caretLineIndex);
        if (caretLinePosition <= 0) {
            this.suggestionRunning = false;
            return;
        }
        if (caretLinePosition > lineText.length()) {
            this.suggestionRunning = false;
            return;
        }
        String text = lineText.substring(0, caretLinePosition);
        int codeIndex = this.editor.getSketch().getCodeIndex(this.editor.getCurrentTab());
        int lineStartOffset = this.editor.getTextArea().getLineStartOffset(caretLineIndex);
        this.editor.getPreprocessingService().whenDone(ps -> {
            int lineNumber = ps.tabOffsetToJavaLine(codeIndex, lineStartOffset);
            String phrase = null;
            DefaultListModel<CompletionCandidate> defListModel = null;
            try {
                Messages.log((String)"phrase parse start");
                phrase = JavaTextArea.parsePhrase(text);
                Messages.log((String)("phrase: " + phrase));
                if (phrase != null) {
                    List<CompletionCandidate> candidates = this.suggestionGenerator.preparePredictions((PreprocessedSketch)ps, phrase, lineNumber);
                    if (!this.suggestionRequested && candidates != null && !candidates.isEmpty()) {
                        Collections.sort(candidates);
                        defListModel = CompletionGenerator.filterPredictions(candidates);
                        Messages.log((String)("Got: " + candidates.size() + " candidates, " + defListModel.size() + " filtered"));
                    }
                }
                String finalPhrase = phrase;
                DefaultListModel<CompletionCandidate> finalDefListModel = defListModel;
                EventQueue.invokeLater(() -> {
                    this.suggestionRunning = false;
                    if (this.suggestionRequested) {
                        Messages.log((String)"completion invalidated");
                        this.fetchPhrase();
                        return;
                    }
                    Messages.log((String)"completion finishing");
                    if (finalDefListModel != null) {
                        this.showSuggestion(finalDefListModel, finalPhrase);
                    } else {
                        this.hideSuggestion();
                    }
                });
            }
            catch (Exception e) {
                Messages.loge((String)"error while preparing suggestions", (Throwable)e);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static String parsePhrase(String lineText) {
        boolean overloading;
        block45: {
            char lastChar;
            block44: {
                overloading = false;
                String trimmedLineText = lineText.trim();
                if (trimmedLineText.length() == 0) {
                    return null;
                }
                lastChar = trimmedLineText.charAt(trimmedLineText.length() - 1);
                if (lastChar != '.') break block44;
                if ((trimmedLineText = trimmedLineText.substring(0, trimmedLineText.length() - 1).trim()).length() == 0) {
                    return null;
                }
                lastChar = trimmedLineText.charAt(trimmedLineText.length() - 1);
                switch (lastChar) {
                    case '\"': 
                    case ')': 
                    case ']': {
                        break block45;
                    }
                    default: {
                        if (!Character.isJavaIdentifierPart(lastChar)) {
                            return null;
                        }
                        break block45;
                    }
                }
            }
            if (lastChar == '(') {
                overloading = true;
            } else if (!Character.isJavaIdentifierPart(lastChar)) {
                return null;
            }
        }
        int currentCharIndex = lineText.length() - 1;
        int commentStart = lineText.indexOf("//", 0);
        if (commentStart >= 0 && currentCharIndex > commentStart) {
            return null;
        }
        BitSet isInLiteral = new BitSet(lineText.length());
        BitSet isInBrackets = new BitSet(lineText.length());
        boolean inString = false;
        boolean inChar = false;
        boolean inEscaped = false;
        for (int i = 0; i < lineText.length(); ++i) {
            block47: {
                block46: {
                    if (inEscaped) break block46;
                    switch (lineText.charAt(i)) {
                        case '\"': {
                            if (!inChar) {
                                inString = !inString;
                                break;
                            }
                            break block47;
                        }
                        case '\'': {
                            if (!inString) {
                                inChar = !inChar;
                                break;
                            }
                            break block47;
                        }
                        case '\\': {
                            if (inString || inChar) {
                                inEscaped = true;
                                break;
                            }
                            break block47;
                        }
                    }
                    break block47;
                }
                inEscaped = false;
            }
            isInLiteral.set(i, inString || inChar);
        }
        if (isInLiteral.get(currentCharIndex)) {
            return null;
        }
        int depth = overloading ? 1 : 0;
        int bracketStart = overloading ? lineText.length() : 0;
        int squareDepth = 0;
        int squareBracketStart = 0;
        block23: for (int i = lineText.length() - 1; i >= 0; --i) {
            if (isInLiteral.get(i)) continue;
            switch (lineText.charAt(i)) {
                case ')': {
                    if (depth == 0) {
                        bracketStart = i;
                    }
                    ++depth;
                    break;
                }
                case '(': {
                    if (--depth == 0) {
                        isInBrackets.set(i, bracketStart);
                        break;
                    }
                    if (depth >= 0) break;
                    break block23;
                }
                case ']': {
                    if (squareDepth == 0) {
                        squareBracketStart = i;
                    }
                    ++squareDepth;
                    break;
                }
                case '[': {
                    if (--squareDepth == 0) {
                        isInBrackets.set(i, squareBracketStart);
                        break;
                    }
                    if (squareDepth < 0) break block23;
                }
            }
        }
        if (depth > 0) {
            isInBrackets.set(0, bracketStart);
        }
        if (squareDepth > 0) {
            isInBrackets.set(0, squareBracketStart);
        }
        int position = currentCharIndex;
        block24: while (position >= 0) {
            char currChar = lineText.charAt(position);
            switch (currChar) {
                case '.': {
                    --position;
                    continue block24;
                }
                case '[': {
                    break block24;
                }
                case ']': {
                    position = isInBrackets.previousClearBit(position - 1);
                    continue block24;
                }
                case '(': {
                    if (!isInBrackets.get(position)) break block24;
                    --position;
                    continue block24;
                }
                case ')': {
                    position = isInBrackets.previousClearBit(position - 1);
                    continue block24;
                }
                case '\"': {
                    position = isInLiteral.previousClearBit(position - 1);
                    break block24;
                }
                default: {
                    if (Character.isJavaIdentifierPart((int)currChar)) {
                        --position;
                        continue block24;
                    }
                    if (!Character.isWhitespace((int)currChar)) break block24;
                    --position;
                    continue block24;
                }
            }
        }
        String phrase = lineText.substring(++position, lineText.length()).trim();
        Messages.log((String)phrase);
        if (phrase.length() != 0 && !Character.isDigit(phrase.charAt(0))) {
            return phrase;
        }
        return null;
    }

    public Image getGutterGradient() {
        return this.gutterGradient;
    }

    public void setGutterText(int lineIdx, String text) {
        this.gutterText.put(lineIdx, text);
        this.painter.invalidateLine(lineIdx);
    }

    public void clearGutterText(int lineIdx) {
        this.gutterText.remove(lineIdx);
        this.painter.invalidateLine(lineIdx);
    }

    public void clearGutterText() {
        for (int lineIdx : this.gutterText.keySet()) {
            this.painter.invalidateLine(lineIdx);
        }
        this.gutterText.clear();
    }

    public String getGutterText(int lineIdx) {
        return this.gutterText.get(lineIdx);
    }

    public int _offsetToX(int line, int offset) {
        return super._offsetToX(line, offset) + 44;
    }

    public int xToOffset(int line, int x) {
        return super.xToOffset(line, x - 44);
    }

    protected void showSuggestion(DefaultListModel<CompletionCandidate> listModel, String subWord) {
        this.hideSuggestion();
        if (listModel.size() == 0) {
            Messages.log((String)"TextArea: No suggestions to show.");
        } else {
            int position = this.getCaretPosition();
            Point location = new Point();
            try {
                location.x = this.offsetToX(this.getCaretLine(), position - this.getLineStartOffset(this.getCaretLine()));
                location.y = this.lineToY(this.getCaretLine()) + this.getPainter().getFontMetrics().getHeight() + this.getPainter().getFontMetrics().getDescent();
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return;
            }
            this.suggestion = new CompletionPanel(this, position, subWord, listModel, location, this.editor);
            this.requestFocusInWindow();
        }
    }

    public void hideSuggestion() {
        if (this.suggestion != null) {
            this.suggestion.setInvisible();
            this.suggestion = null;
        }
    }

    public void removeAllListeners() {
        ComponentListener[] componentListeners = this.painter.getComponentListeners();
        MouseListener[] mouseListeners = this.painter.getMouseListeners();
        MouseMotionListener[] mouseMotionListeners = this.painter.getMouseMotionListeners();
        KeyListener[] keyListeners = this.editor.getKeyListeners();
        for (ComponentListener componentListener : componentListeners) {
            this.painter.removeComponentListener(componentListener);
        }
        for (EventListener eventListener : mouseListeners) {
            this.painter.removeMouseListener((MouseListener)eventListener);
        }
        for (EventListener eventListener : mouseMotionListeners) {
            this.painter.removeMouseMotionListener((MouseMotionListener)eventListener);
        }
        for (EventListener eventListener : keyListeners) {
            this.editor.removeKeyListener((KeyListener)eventListener);
        }
    }

    public void startTweakMode() {
        if (!this.tweakMode) {
            this.removeAllListeners();
            this.getCustomPainter().startTweakMode();
            this.editable = false;
            this.caretBlinks = false;
            this.setCaretVisible(false);
            this.tweakMode = true;
        }
    }

    public void stopTweakMode() {
        if (this.tweakMode) {
            this.removeAllListeners();
            this.addPrevListeners();
            this.getCustomPainter().stopTweakMode();
            this.editable = true;
            this.caretBlinks = true;
            this.setCaretVisible(true);
            this.tweakMode = false;
        }
    }

    private void addPrevListeners() {
        for (ComponentListener componentListener : this.prevCompListeners) {
            this.painter.addComponentListener(componentListener);
        }
        for (EventListener eventListener : this.prevMouseListeners) {
            this.painter.addMouseListener((MouseListener)eventListener);
        }
        for (EventListener eventListener : this.prevMMotionListeners) {
            this.painter.addMouseMotionListener((MouseMotionListener)eventListener);
        }
        for (EventListener eventListener : this.prevKeyListeners) {
            this.editor.addKeyListener((KeyListener)eventListener);
        }
    }

    public void updateInterface(List<List<Handle>> handles, List<List<ColorControlBox>> colorBoxes) {
        this.getCustomPainter().updateInterface(handles, colorBoxes);
    }
}

