/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.runner;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import processing.mode.java.runner.MessageConsumer;

public class MessageSiphon
implements Runnable {
    BufferedReader streamReader;
    Thread thread;
    MessageConsumer consumer;

    public MessageSiphon(InputStream stream, MessageConsumer consumer) {
        this.streamReader = new BufferedReader(new InputStreamReader(stream));
        this.consumer = consumer;
        this.thread = new Thread(this);
        this.thread.setPriority(9);
    }

    @Override
    public void run() {
        try {
            String currentLine;
            while ((currentLine = this.streamReader.readLine()) != null) {
                this.consumer.message(currentLine + "\n");
            }
            this.thread = null;
        }
        catch (NullPointerException npe) {
            this.thread = null;
        }
        catch (Exception e) {
            String mess = e.getMessage();
            if (mess == null || mess.indexOf("Bad file descriptor") == -1) {
                e.printStackTrace();
            }
            this.thread = null;
        }
    }

    public Thread getThread() {
        return this.thread;
    }
}

