/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.File;
import java.util.Properties;
import java.util.StringTokenizer;
import org.python.core.PathPackageManager;
import org.python.core.Py;
import org.python.core.PyJavaPackage;
import org.python.core.PyList;
import org.python.core.PySystemState;

public class SysPackageManager
extends PathPackageManager {
    protected void message(String string) {
        Py.writeMessage("*sys-package-mgr*", string);
    }

    protected void warning(String string) {
        Py.writeWarning("*sys-package-mgr*", string);
    }

    protected void comment(String string) {
        Py.writeComment("*sys-package-mgr*", string);
    }

    protected void debug(String string) {
        Py.writeDebug("*sys-package-mgr*", string);
    }

    public SysPackageManager(File file, Properties properties) {
        if (this.useCacheDir(file)) {
            this.initCache();
            this.findAllPackages(properties);
            this.saveCache();
        }
    }

    public void addJar(String string, boolean bl) {
        this.addJarToPackages(new File(string), bl);
        if (bl) {
            this.saveCache();
        }
    }

    public void addJarDir(String string, boolean bl) {
        this.addJarDir(string, bl, bl);
    }

    private void addJarDir(String string, boolean bl, boolean bl2) {
        File file = new File(string);
        if (!file.isDirectory()) {
            return;
        }
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string2.endsWith(".jar") && !string2.endsWith(".zip")) continue;
            this.addJarToPackages(new File(string, string2), bl);
        }
        if (bl2) {
            this.saveCache();
        }
    }

    private void addJarPath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.addJarDir(string2, true, false);
        }
    }

    private void findAllPackages(Properties properties) {
        String string;
        String string2;
        String string3 = properties.getProperty("python.packages.paths", "java.class.path,sun.boot.class.path");
        String string4 = properties.getProperty("python.packages.directories", "java.ext.dirs");
        String string5 = properties.getProperty("python.packages.fakepath", null);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().trim();
            string = properties.getProperty(string2);
            if (string == null) continue;
            this.addClassPath(string);
        }
        stringTokenizer = new StringTokenizer(string4, ",");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().trim();
            string = properties.getProperty(string2);
            if (string == null) continue;
            this.addJarPath(string);
        }
        if (string5 != null) {
            this.addClassPath(string5);
        }
    }

    public void notifyPackageImport(String string, String string2) {
        if (string != null && string.length() > 0) {
            string2 = string + '.' + string2;
        }
        Py.writeComment("import", "'" + string2 + "' as java package");
    }

    public Class findClass(String string, String string2) {
        Class clazz = super.findClass(string, string2);
        if (clazz != null) {
            Py.writeComment("import", "'" + string2 + "' as java class");
        }
        return clazz;
    }

    public Class findClass(String string, String string2, String string3) {
        if (string != null && string.length() > 0) {
            string2 = string + '.' + string2;
        }
        return Py.findClassEx(string2, string3);
    }

    public PyList doDir(PyJavaPackage pyJavaPackage, boolean bl, boolean bl2) {
        PyList pyList = this.basicDoDir(pyJavaPackage, bl, bl2);
        PyList pyList2 = new PyList();
        this.doDir(this.searchPath, pyList2, pyJavaPackage, bl, bl2);
        PySystemState pySystemState = Py.getSystemState();
        if (pySystemState.getClassLoader() == null) {
            this.doDir(pySystemState.path, pyList2, pyJavaPackage, bl, bl2);
        }
        return this.merge(pyList, pyList2);
    }

    public boolean packageExists(String string, String string2) {
        if (this.packageExists(this.searchPath, string, string2)) {
            return true;
        }
        PySystemState pySystemState = Py.getSystemState();
        return pySystemState.getClassLoader() == null && this.packageExists(Py.getSystemState().path, string, string2);
    }
}

