/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.fields;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.revapi.Difference;
import org.revapi.java.checks.fields.BothFieldsRequiringCheck;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaFieldElement;

public final class NoLongerConstant
extends BothFieldsRequiringCheck {
    @Override
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.FIELD);
    }

    protected void doVisitField(JavaFieldElement oldField, JavaFieldElement newField) {
        if (!this.shouldCheck(oldField, newField)) {
            return;
        }
        if (oldField.getDeclaringElement().getConstantValue() != null && newField.getDeclaringElement().getConstantValue() == null) {
            this.pushActive((JavaElement)oldField, (JavaElement)newField, new Object[0]);
        }
    }

    protected List<Difference> doEnd() {
        CheckBase.ActiveElements fields = this.popIfActive();
        if (fields == null) {
            return null;
        }
        return Collections.singletonList(this.createDifference(Code.FIELD_NO_LONGER_CONSTANT, new Object[]{((JavaFieldElement)fields.oldElement).getDeclaringElement().getConstantValue()}));
    }
}

