/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.fields;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.type.TypeMirror;
import org.revapi.Difference;
import org.revapi.java.checks.fields.BothFieldsRequiringCheck;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaFieldElement;
import org.revapi.java.spi.Util;

public final class TypeChanged
extends BothFieldsRequiringCheck {
    @Override
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.FIELD);
    }

    protected void doVisitField(JavaFieldElement oldField, JavaFieldElement newField) {
        String newType;
        if (!this.shouldCheck(oldField, newField)) {
            return;
        }
        String oldType = Util.toUniqueString((TypeMirror)oldField.getTypeEnvironment().getTypeUtils().erasure(oldField.getModelRepresentation()));
        if (!oldType.equals(newType = Util.toUniqueString((TypeMirror)newField.getTypeEnvironment().getTypeUtils().erasure(newField.getModelRepresentation())))) {
            this.pushActive((JavaElement)oldField, (JavaElement)newField, new Object[0]);
        }
    }

    protected List<Difference> doEnd() {
        CheckBase.ActiveElements fields = this.popIfActive();
        if (fields == null) {
            return null;
        }
        String oldType = Util.toHumanReadableString((AnnotatedConstruct)((JavaFieldElement)fields.oldElement).getModelRepresentation());
        String newType = Util.toHumanReadableString((AnnotatedConstruct)((JavaFieldElement)fields.newElement).getModelRepresentation());
        return Collections.singletonList(this.createDifference(Code.FIELD_TYPE_CHANGED, new String[]{oldType, newType}, new Object[]{((JavaFieldElement)fields.oldElement).getModelRepresentation(), ((JavaFieldElement)fields.newElement).getModelRepresentation()}));
    }
}

