/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.model;

import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.type.TypeMirror;
import org.revapi.API;
import org.revapi.Archive;
import org.revapi.Element;
import org.revapi.java.compilation.ProbingEnvironment;
import org.revapi.java.model.JavaElementFactory;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaModelElement;
import org.revapi.java.spi.JavaTypeElement;
import org.revapi.java.spi.TypeEnvironment;
import org.revapi.java.spi.Util;
import org.revapi.simple.SimpleElement;

public abstract class JavaElementBase<E extends javax.lang.model.element.Element, T extends TypeMirror>
extends SimpleElement
implements JavaModelElement {
    protected final ProbingEnvironment environment;
    protected final E element;
    protected final T representation;
    private final Archive archive;
    private String comparableSignature;
    private boolean inherited = false;
    private String stringRepre;

    JavaElementBase(ProbingEnvironment env, Archive archive, E element, T representation) {
        this.environment = env;
        this.element = element;
        this.archive = archive;
        this.representation = representation;
    }

    @Nonnull
    protected abstract String getHumanReadableElementType();

    @Nullable
    public JavaModelElement getParent() {
        return (JavaModelElement)super.getParent();
    }

    public void setParent(@Nullable Element parent) {
        if (parent != null && !(parent instanceof JavaModelElement)) {
            throw new IllegalArgumentException("A parent must be a java model element.");
        }
        super.setParent(parent);
    }

    @Nonnull
    public API getApi() {
        return this.environment.getApi();
    }

    @Nullable
    public Archive getArchive() {
        return this.archive;
    }

    public int compareTo(@Nonnull Element o) {
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return JavaElementFactory.compareByType((Element)this, o);
        }
        return this.getComparableSignature().compareTo(((JavaElementBase)o).getComparableSignature());
    }

    @Nonnull
    public TypeEnvironment getTypeEnvironment() {
        return this.environment;
    }

    public E getDeclaringElement() {
        return this.element;
    }

    public T getModelRepresentation() {
        return this.representation;
    }

    @Nonnull
    public SortedSet<JavaElement> getChildren() {
        return super.getChildren();
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    @Nonnull
    public final String getFullHumanReadableString() {
        if (this.environment.isScanningComplete() && this.stringRepre != null) {
            return this.stringRepre;
        }
        String ret = this.createFullHumanReadableString();
        if (this.environment.isScanningComplete()) {
            this.stringRepre = ret;
        }
        return ret;
    }

    protected String createFullHumanReadableString() {
        String decl = Util.toHumanReadableString(this.getDeclaringElement());
        if (this.isInherited()) {
            JavaModelElement parent;
            for (parent = this.getParent(); parent != null && !(parent instanceof JavaTypeElement); parent = parent.getParent()) {
            }
            JavaTypeElement parentType = (JavaTypeElement)parent;
            if (parentType != null) {
                decl = decl + " @ " + Util.toHumanReadableString((AnnotatedConstruct)parentType.getDeclaringElement());
            }
        }
        return this.getHumanReadableElementType() + " " + decl;
    }

    public int hashCode() {
        return this.getFullHumanReadableString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj != null && obj instanceof JavaElementBase && this.getFullHumanReadableString().equals(((JavaElementBase)((Object)obj)).getFullHumanReadableString());
    }

    public String toString() {
        return this.getFullHumanReadableString();
    }

    protected String getComparableSignature() {
        if (this.comparableSignature == null) {
            this.comparableSignature = this.createComparableSignature();
        }
        return this.comparableSignature;
    }

    protected abstract String createComparableSignature();
}

