/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.annotations;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.type.TypeMirror;
import org.revapi.Difference;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.Util;

public final class AttributeValueChanged
extends CheckBase {
    protected List<Difference> doVisitAnnotation(AnnotationMirror oldAnnotation, AnnotationMirror newAnnotation) {
        String name;
        if (oldAnnotation == null || newAnnotation == null) {
            return null;
        }
        ArrayList<Difference> result = new ArrayList<Difference>();
        Map oldAttrs = Util.keyAnnotationAttributesByName(oldAnnotation.getElementValues());
        Map newAttrs = Util.keyAnnotationAttributesByName(newAnnotation.getElementValues());
        for (Map.Entry oldE : oldAttrs.entrySet()) {
            name = (String)oldE.getKey();
            Map.Entry oldValue = (Map.Entry)oldE.getValue();
            Map.Entry newValue = (Map.Entry)newAttrs.get(name);
            if (newValue == null) {
                result.add(this.createDifference(Code.ANNOTATION_ATTRIBUTE_REMOVED, new String[]{name, Util.toHumanReadableString((TypeMirror)oldAnnotation.getAnnotationType())}, new Object[]{oldValue.getKey(), oldAnnotation}));
            } else if (!Util.isEqual((AnnotationValue)((AnnotationValue)oldValue.getValue()), (AnnotationValue)((AnnotationValue)newValue.getValue()))) {
                result.add(this.createDifference(Code.ANNOTATION_ATTRIBUTE_VALUE_CHANGED, new String[]{name, Util.toHumanReadableString((TypeMirror)oldAnnotation.getAnnotationType()), Util.toHumanReadableString((AnnotationValue)((AnnotationValue)oldValue.getValue())), Util.toHumanReadableString((AnnotationValue)((AnnotationValue)newValue.getValue()))}, new Object[]{oldValue.getKey(), oldAnnotation, oldValue.getValue(), newValue.getValue()}));
            }
            newAttrs.remove(name);
        }
        for (Map.Entry newE : newAttrs.entrySet()) {
            name = (String)newE.getKey();
            Map.Entry newValue = (Map.Entry)newE.getValue();
            Map.Entry oldValue = (Map.Entry)oldAttrs.get(name);
            if (oldValue != null) continue;
            result.add(this.createDifference(Code.ANNOTATION_ATTRIBUTE_ADDED, new String[]{name, Util.toHumanReadableString((TypeMirror)newAnnotation.getAnnotationType())}, new Object[]{newValue.getKey(), newAnnotation}));
        }
        return result.isEmpty() ? null : result;
    }
}

