/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.methods;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.revapi.Difference;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.Util;

public final class ParameterTypeChanged
extends CheckBase {
    protected void doVisitMethodParameter(@Nullable VariableElement oldParameter, @Nullable VariableElement newParameter) {
        String newType;
        if (oldParameter == null || newParameter == null) {
            return;
        }
        if (ParameterTypeChanged.isBothPrivate((Element)oldParameter.getEnclosingElement(), (Element)newParameter.getEnclosingElement())) {
            return;
        }
        String oldType = Util.toUniqueString((TypeMirror)oldParameter.asType());
        if (!oldType.equals(newType = Util.toUniqueString((TypeMirror)newParameter.asType()))) {
            this.pushActive(oldParameter, newParameter, new Object[0]);
        }
    }

    @Nullable
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements params = this.popIfActive();
        if (params == null) {
            return null;
        }
        String oldType = Util.toHumanReadableString((TypeMirror)((VariableElement)params.oldElement).asType());
        String newType = Util.toHumanReadableString((TypeMirror)((VariableElement)params.newElement).asType());
        return Collections.singletonList(this.createDifference(Code.METHOD_PARAMETER_TYPE_CHANGED, new Object[]{oldType, newType}));
    }
}

