/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java;

import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.revapi.API;
import org.revapi.AnalysisContext;
import org.revapi.ApiAnalyzer;
import org.revapi.ArchiveAnalyzer;
import org.revapi.DifferenceAnalyzer;
import org.revapi.java.AnalysisConfiguration;
import org.revapi.java.JavaArchiveAnalyzer;
import org.revapi.java.JavaElementDifferenceAnalyzer;
import org.revapi.java.compilation.CompilationValve;
import org.revapi.java.compilation.ProbingEnvironment;
import org.revapi.java.spi.Check;

public final class JavaApiAnalyzer
implements ApiAnalyzer {
    private final ExecutorService compilationExecutor = Executors.newFixedThreadPool(2, new ThreadFactory(){
        private volatile int cnt;

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "Java API Compilation Thread #" + ++this.cnt);
        }
    });
    private AnalysisContext analysisContext;
    private AnalysisConfiguration configuration;
    private final Iterable<Check> checks;

    public JavaApiAnalyzer() {
        this(ServiceLoader.load(Check.class, JavaApiAnalyzer.class.getClassLoader()));
    }

    public JavaApiAnalyzer(Iterable<Check> checks) {
        this.checks = checks;
    }

    @Nullable
    public String[] getConfigurationRootPaths() {
        ArrayList<String> checkConfigPaths = new ArrayList<String>();
        checkConfigPaths.add("revapi.java");
        for (Check c : this.checks) {
            String[] cp = c.getConfigurationRootPaths();
            if (cp == null) continue;
            checkConfigPaths.addAll(Arrays.asList(cp));
        }
        String[] configs = new String[checkConfigPaths.size()];
        configs = checkConfigPaths.toArray(configs);
        return configs;
    }

    @Nullable
    public Reader getJSONSchema(@Nonnull String configurationRootPath) {
        if ("revapi.java".equals(configurationRootPath)) {
            return new InputStreamReader(this.getClass().getResourceAsStream("/META-INF/config-schema.json"), Charset.forName("UTF-8"));
        }
        for (Check check : this.checks) {
            String[] roots = check.getConfigurationRootPaths();
            if (roots == null) continue;
            for (String root : check.getConfigurationRootPaths()) {
                if (!configurationRootPath.equals(root)) continue;
                return check.getJSONSchema(root);
            }
        }
        return null;
    }

    public void initialize(@Nonnull AnalysisContext analysisContext) {
        this.analysisContext = analysisContext;
        this.configuration = AnalysisConfiguration.fromModel(analysisContext.getConfiguration());
    }

    @Nonnull
    public ArchiveAnalyzer getArchiveAnalyzer(@Nonnull API api) {
        Set<File> bootstrapClasspath = api == this.analysisContext.getOldApi() ? this.configuration.getOldApiBootstrapClasspath() : this.configuration.getNewApiBootstrapClasspath();
        boolean ignoreMissingAnnotations = this.configuration.isIgnoreMissingAnnotations();
        boolean ignoreAdditionalClasspathContributions = this.configuration.isIgnoreAdditionalClasspathContributions();
        return new JavaArchiveAnalyzer(api, this.compilationExecutor, this.configuration.getMissingClassReporting(), ignoreMissingAnnotations, bootstrapClasspath, ignoreAdditionalClasspathContributions);
    }

    @Nonnull
    public DifferenceAnalyzer getDifferenceAnalyzer(@Nonnull ArchiveAnalyzer oldArchive, @Nonnull ArchiveAnalyzer newArchive) {
        JavaArchiveAnalyzer oldA = (JavaArchiveAnalyzer)oldArchive;
        JavaArchiveAnalyzer newA = (JavaArchiveAnalyzer)newArchive;
        ProbingEnvironment oldEnvironment = oldA.getProbingEnvironment();
        ProbingEnvironment newEnvironment = newA.getProbingEnvironment();
        CompilationValve oldValve = oldA.getCompilationValve();
        CompilationValve newValve = newA.getCompilationValve();
        return new JavaElementDifferenceAnalyzer(this.analysisContext, oldEnvironment, oldValve, newEnvironment, newValve, this.checks, this.configuration);
    }

    public void close() {
        this.compilationExecutor.shutdown();
    }
}

