/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.methods;

import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.revapi.Difference;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.Util;

public final class DefaultValueChanged
extends CheckBase {
    @Override
    protected List<Difference> doEnd() {
        String nv;
        CheckBase.ActiveElements methods = this.popIfActive();
        if (methods == null) {
            return null;
        }
        AnnotationValue oldValue = ((ExecutableElement)methods.oldElement).getDefaultValue();
        AnnotationValue newValue = ((ExecutableElement)methods.newElement).getDefaultValue();
        String attribute = ((ExecutableElement)methods.oldElement).getSimpleName().toString();
        String annotationType = ((TypeElement)((ExecutableElement)methods.oldElement).getEnclosingElement()).getQualifiedName().toString();
        String ov = oldValue == null ? null : Util.toHumanReadableString(oldValue);
        String string = nv = newValue == null ? null : Util.toHumanReadableString(newValue);
        Difference difference = ov == null ? this.createDifference(Code.METHOD_DEFAULT_VALUE_ADDED, new Object[0]) : (nv == null ? this.createDifference(Code.METHOD_DEFAULT_VALUE_REMOVED, new Object[0]) : this.createDifference(Code.METHOD_DEFAULT_VALUE_CHANGED, (Object[])new String[]{attribute, annotationType, ov, nv}, new Object[]{oldValue, newValue}));
        return Collections.singletonList(difference);
    }

    @Override
    protected void doVisitMethod(ExecutableElement oldMethod, ExecutableElement newMethod) {
        boolean equal;
        if (oldMethod == null || newMethod == null || DefaultValueChanged.isBothPrivate(oldMethod, newMethod)) {
            return;
        }
        AnnotationValue oldVal = oldMethod.getDefaultValue();
        AnnotationValue newVal = newMethod.getDefaultValue();
        boolean bl = equal = oldVal != null && newVal != null && Util.isEqual(oldVal, newVal) || oldVal == null && newVal == null;
        if (!equal) {
            this.pushActive(oldMethod, newMethod, new Object[0]);
        }
    }
}

