/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.compilation;

import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.revapi.java.model.MissingTypeElement;
import org.revapi.java.spi.IgnoreCompletionFailures;

final class MissingTypeAwareDelegatingElements
implements Elements {
    private final Elements elements;

    MissingTypeAwareDelegatingElements(Elements elements) {
        this.elements = elements;
    }

    @Override
    public PackageElement getPackageElement(CharSequence name) {
        return IgnoreCompletionFailures.in(this.elements::getPackageElement, name);
    }

    @Override
    public TypeElement getTypeElement(CharSequence name) {
        return IgnoreCompletionFailures.in(this.elements::getTypeElement, name);
    }

    @Override
    public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValuesWithDefaults(AnnotationMirror a) {
        return IgnoreCompletionFailures.in(this.elements::getElementValuesWithDefaults, a);
    }

    @Override
    public String getDocComment(Element e) {
        if (MissingTypeElement.isMissing(e)) {
            return "";
        }
        return IgnoreCompletionFailures.in(this.elements::getDocComment, e);
    }

    @Override
    public boolean isDeprecated(Element e) {
        if (MissingTypeElement.isMissing(e)) {
            return false;
        }
        return IgnoreCompletionFailures.in(this.elements::isDeprecated, e);
    }

    @Override
    public Name getBinaryName(TypeElement type) {
        if (MissingTypeElement.isMissing(type)) {
            return type.getQualifiedName();
        }
        return IgnoreCompletionFailures.in(this.elements::getBinaryName, type);
    }

    @Override
    public PackageElement getPackageOf(Element type) {
        if (MissingTypeElement.isMissing(type)) {
            String binaryName = ((MissingTypeElement)type).getQualifiedName().toString();
            int lastDot = binaryName.lastIndexOf(46);
            return this.elements.getPackageElement(binaryName.substring(0, lastDot));
        }
        return IgnoreCompletionFailures.in(this.elements::getPackageOf, type);
    }

    @Override
    public List<? extends Element> getAllMembers(TypeElement type) {
        if (MissingTypeElement.isMissing(type)) {
            return Collections.emptyList();
        }
        return IgnoreCompletionFailures.in(this.elements::getAllMembers, type);
    }

    @Override
    public List<? extends AnnotationMirror> getAllAnnotationMirrors(Element e) {
        if (MissingTypeElement.isMissing(e)) {
            return Collections.emptyList();
        }
        return IgnoreCompletionFailures.in(this.elements::getAllAnnotationMirrors, e);
    }

    @Override
    public boolean hides(Element hider, Element hidden) {
        if (MissingTypeElement.isMissing(hider) || MissingTypeElement.isMissing(hidden)) {
            return false;
        }
        return IgnoreCompletionFailures.in(this.elements::hides, hider, hidden);
    }

    @Override
    public boolean overrides(ExecutableElement overrider, ExecutableElement overridden, TypeElement type) {
        if (MissingTypeElement.isMissing(type)) {
            return false;
        }
        return IgnoreCompletionFailures.in(this.elements::overrides, overrider, overridden, type);
    }

    @Override
    public String getConstantExpression(Object value) {
        return IgnoreCompletionFailures.in(this.elements::getConstantExpression, value);
    }

    @Override
    public void printElements(Writer w, Element ... elems) {
        IgnoreCompletionFailures.inVoid(this.elements::printElements, w, elems);
    }

    @Override
    public boolean isFunctionalInterface(TypeElement type) {
        return this.elements.isFunctionalInterface(type);
    }

    @Override
    public Name getName(CharSequence cs) {
        try {
            return this.elements.getName(cs);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }
}

