/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.classes;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaModelElement;
import org.revapi.java.spi.JavaTypeElement;
import org.revapi.java.spi.Util;

public final class NowImplementsInterface
extends CheckBase {
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.CLASS);
    }

    protected void doVisitClass(JavaTypeElement oldType, JavaTypeElement newType) {
        if (!this.isBothAccessible((JavaModelElement)oldType, (JavaModelElement)newType)) {
            return;
        }
        List<? extends TypeMirror> newInterfaces = newType.getDeclaringElement().getInterfaces();
        List<? extends TypeMirror> oldInterfaces = oldType.getDeclaringElement().getInterfaces();
        for (TypeMirror typeMirror : newInterfaces) {
            if (Util.isSubtype((TypeMirror)typeMirror, oldInterfaces, (Types)this.getNewTypeEnvironment().getTypeUtils())) continue;
            this.pushActive((JavaElement)oldType, (JavaElement)newType, new Object[0]);
            break;
        }
    }

    protected List<Difference> doEnd() {
        CheckBase.ActiveElements types = this.popIfActive();
        if (types == null) {
            return null;
        }
        ArrayList<Difference> result = new ArrayList<Difference>();
        List<? extends TypeMirror> newInterfaces = ((JavaTypeElement)types.newElement).getDeclaringElement().getInterfaces();
        List<? extends TypeMirror> oldInterfaces = ((JavaTypeElement)types.oldElement).getDeclaringElement().getInterfaces();
        for (TypeMirror typeMirror : newInterfaces) {
            if (Util.isSubtype((TypeMirror)typeMirror, oldInterfaces, (Types)this.getNewTypeEnvironment().getTypeUtils())) continue;
            result.add(this.createDifference(Code.CLASS_NOW_IMPLEMENTS_INTERFACE, Code.attachmentsFor((JavaElement)types.oldElement, (JavaElement)types.newElement, (String[])new String[]{"interface", Util.toHumanReadableString((AnnotatedConstruct)typeMirror)})));
        }
        return result;
    }
}

