/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.compilation;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.revapi.Archive;
import org.revapi.TreeFilter;
import org.revapi.java.AnalysisConfiguration;
import org.revapi.java.Timing;
import org.revapi.java.compilation.ArchiveProbeObject;
import org.revapi.java.compilation.ClasspathScanner;
import org.revapi.java.compilation.CompilationValve;
import org.revapi.java.compilation.MarkerAnnotationObject;
import org.revapi.java.compilation.ProbingAnnotationProcessor;
import org.revapi.java.compilation.ProbingEnvironment;
import org.revapi.java.spi.JarExtractor;
import org.revapi.java.spi.JavaElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Compiler {
    private static final Logger LOG = LoggerFactory.getLogger(Compiler.class);
    private final JavaCompiler compiler;
    private final Writer output;
    private final Iterable<? extends Archive> classPath;
    private final Iterable<? extends Archive> additionalClassPath;
    private final ExecutorService executor;
    private final TreeFilter<JavaElement> filter;
    private final Iterable<JarExtractor> jarExtractors;

    public Compiler(ExecutorService executor, Writer reportingOutput, Iterable<JarExtractor> jarExtractors, Iterable<? extends Archive> classPath, Iterable<? extends Archive> additionalClassPath, TreeFilter<JavaElement> filter) {
        this.jarExtractors = jarExtractors;
        this.compiler = ToolProvider.getSystemJavaCompiler();
        if (this.compiler == null) {
            throw new AssertionError((Object)"Could not obtain the system compiler. Is tools.jar on the classpath?");
        }
        this.executor = executor;
        this.output = reportingOutput;
        this.classPath = classPath;
        this.additionalClassPath = additionalClassPath;
        this.filter = filter;
    }

    public CompilationValve compile(ProbingEnvironment environment, AnalysisConfiguration.MissingClassReporting missingClassReporting, boolean ignoreMissingAnnotations) throws Exception {
        File targetPath = Files.createTempDirectory("revapi-java", new FileAttribute[0]).toAbsolutePath().toFile();
        File sourceDir = new File(targetPath, "sources");
        sourceDir.mkdir();
        File lib = new File(targetPath, "lib");
        lib.mkdir();
        int classPathSize = this.size(this.classPath);
        int nofArchives = classPathSize + this.size(this.additionalClassPath);
        int prefixLength = (int)Math.log10(nofArchives) + 1;
        IdentityHashMap<Archive, File> classPathFiles = this.copyArchives(this.classPath, lib, 0, prefixLength);
        IdentityHashMap<Archive, File> additionClassPathFiles = this.copyArchives(this.additionalClassPath, lib, classPathSize, prefixLength);
        List<String> options = Arrays.asList("-d", sourceDir.toString(), "-cp", this.composeClassPath(lib));
        List<JavaFileObject> sources = Arrays.asList(new MarkerAnnotationObject(), new ArchiveProbeObject());
        StandardJavaFileManager fileManager = this.compiler.getStandardFileManager(null, Locale.getDefault(), Charset.forName("UTF-8"));
        JavaCompiler.CompilationTask task = this.compiler.getTask(this.output, fileManager, null, options, Collections.singletonList("Probe"), sources);
        ProbingAnnotationProcessor processor = new ProbingAnnotationProcessor(environment);
        task.setProcessors(Collections.singletonList(processor));
        Future<Boolean> future = processor.submitWithCompilationAwareness(this.executor, task, () -> {
            if (Timing.LOG.isDebugEnabled()) {
                Timing.LOG.debug("About to crawl " + environment.getApi());
            }
            try {
                new ClasspathScanner(fileManager, environment, classPathFiles, additionClassPathFiles, missingClassReporting, ignoreMissingAnnotations, this.filter).initTree();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to scan the classpath.", e);
            }
            if (Timing.LOG.isDebugEnabled()) {
                Timing.LOG.debug("Crawl finished for " + environment.getApi());
            }
        });
        return new CompilationValve(future, targetPath, environment, fileManager);
    }

    private String composeClassPath(File classPathDir) {
        StringBuilder bld = new StringBuilder();
        File[] jars = classPathDir.listFiles();
        if (jars == null || jars.length == 0) {
            return "";
        }
        ArrayList<File> sortedJars = new ArrayList<File>(Arrays.asList(jars));
        Collections.sort(sortedJars, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        Iterator it = sortedJars.iterator();
        bld.append(((File)it.next()).getAbsolutePath());
        while (it.hasNext()) {
            bld.append(File.pathSeparator).append(((File)it.next()).getAbsolutePath());
        }
        return bld.toString();
    }

    private IdentityHashMap<Archive, File> copyArchives(Iterable<? extends Archive> archives, File parentDir, int startIdx, int prefixLength) {
        IdentityHashMap<Archive, File> ret = new IdentityHashMap<Archive, File>();
        if (archives == null) {
            return ret;
        }
        for (Archive archive : archives) {
            String name = this.formatName(startIdx++, prefixLength, archive.getName());
            File f = new File(parentDir, name);
            ret.put(archive, f);
            if (f.exists()) {
                LOG.warn("File " + f.getAbsolutePath() + " with the data of archive '" + archive.getName() + "' already exists. Assume it already contains the bits we need.");
                continue;
            }
            Path target = new File(parentDir, name).toPath();
            try {
                InputStream data = this.extracted(archive);
                Throwable throwable = null;
                try {
                    Files.copy(data, target, new CopyOption[0]);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (data == null) continue;
                    if (throwable != null) {
                        try {
                            data.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    data.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to copy class path element: " + archive.getName() + " to " + f.getAbsolutePath(), e);
            }
        }
        return ret;
    }

    private InputStream extracted(Archive archive) throws IOException {
        for (JarExtractor t : this.jarExtractors) {
            Optional extracted = t.extract(archive);
            if (!extracted.isPresent()) continue;
            return (InputStream)extracted.get();
        }
        return archive.openStream();
    }

    private int size(Iterable<?> collection) {
        if (collection == null) {
            return 0;
        }
        int ret = 0;
        Iterator<?> it = collection.iterator();
        while (it.hasNext()) {
            ++ret;
            it.next();
        }
        return ret;
    }

    private String formatName(int idx, int prefixLength, String rootName) {
        try {
            return String.format("%0" + prefixLength + "d-%s", idx, UUID.nameUUIDFromBytes(rootName.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 not supported.");
        }
    }
}

