/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.model;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.revapi.API;
import org.revapi.Element;
import org.revapi.base.BaseElementForest;
import org.revapi.java.Timing;
import org.revapi.java.spi.JavaElement;
import org.revapi.query.Filter;

public final class JavaElementForest
extends BaseElementForest<JavaElement> {
    private Future<?> compilation;
    private static final ThreadLocal<Boolean> UNSAFE_MODE = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public JavaElementForest(API api) {
        super(api);
    }

    public void setCompilationFuture(Future<?> compilation) {
        this.compilation = compilation;
    }

    public SortedSet<JavaElement> getRoots() {
        this.waitForCompilation();
        return super.getRoots();
    }

    public SortedSet<JavaElement> getRootsUnsafe() {
        boolean wasUnsafe = UNSAFE_MODE.get();
        try {
            UNSAFE_MODE.set(true);
            SortedSet sortedSet = super.getRoots();
            return sortedSet;
        }
        finally {
            UNSAFE_MODE.set(wasUnsafe);
        }
    }

    @Nonnull
    public <T extends Element<T>> Iterator<T> iterateOverElements(@Nonnull Class<T> resultType, boolean recurse, @Nullable Filter<? super T> filter, @Nullable Element<T> searchRoot) {
        this.waitForCompilation();
        return super.iterateOverElements(resultType, recurse, filter, searchRoot);
    }

    @Nonnull
    public <T extends Element<JavaElement>> Stream<T> stream(@Nonnull Class<T> resultType, boolean recurse, @Nullable Element<JavaElement> searchRoot) {
        this.waitForCompilation();
        return super.stream(resultType, recurse, searchRoot);
    }

    public String toString() {
        boolean unsafe = UNSAFE_MODE.get();
        try {
            UNSAFE_MODE.set(true);
            String string = super.toString();
            return string;
        }
        finally {
            UNSAFE_MODE.set(unsafe);
        }
    }

    private void waitForCompilation() {
        try {
            if (this.compilation != null && !UNSAFE_MODE.get().booleanValue()) {
                this.compilation.get();
                this.compilation = null;
                if (Timing.LOG.isDebugEnabled()) {
                    Timing.LOG.debug("Compilation completed for " + this.getApi());
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted while waiting for compilation to finish.");
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Failed to obtain class tree due to compilation failure.", e.getCause());
        }
    }
}

