/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.matcher;

import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.lang.model.element.PackageElement;
import org.revapi.ArchiveAnalyzer;
import org.revapi.Element;
import org.revapi.ElementMatcher;
import org.revapi.FilterStartResult;
import org.revapi.Ternary;
import org.revapi.TreeFilter;
import org.revapi.base.BaseElementMatcher;
import org.revapi.base.IndependentTreeFilter;
import org.revapi.java.JavaArchiveAnalyzer;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaModelElement;

public class PackageMatcher
extends BaseElementMatcher {
    public Optional<ElementMatcher.CompiledRecipe> compile(final String recipe) {
        return Optional.of(new ElementMatcher.CompiledRecipe(){
            final Pattern pattern;
            {
                this.pattern = recipe.length() > 1 && recipe.startsWith("/") && recipe.endsWith("/") ? Pattern.compile(recipe.substring(1, recipe.length() - 1)) : null;
            }

            @Nullable
            public <E extends Element<E>> TreeFilter<E> filterFor(ArchiveAnalyzer<E> archiveAnalyzer) {
                if (!(archiveAnalyzer instanceof JavaArchiveAnalyzer)) {
                    return null;
                }
                return new IndependentTreeFilter<JavaElement>(){

                    protected FilterStartResult doStart(JavaElement element) {
                        if (!(element instanceof JavaModelElement)) {
                            return FilterStartResult.defaultResult();
                        }
                        JavaModelElement modelElement = (JavaModelElement)element;
                        PackageElement pkg = this.getPackage(modelElement.getDeclaringElement());
                        Ternary ret = Ternary.fromBoolean((boolean)this.matches(pkg));
                        return FilterStartResult.direct((Ternary)ret, (Ternary)ret);
                    }

                    private PackageElement getPackage(javax.lang.model.element.Element el) {
                        while (!(el instanceof PackageElement)) {
                            el = el.getEnclosingElement();
                        }
                        return (PackageElement)el;
                    }

                    private boolean matches(PackageElement pkg) {
                        if (pattern == null) {
                            return recipe.contentEquals(pkg.getQualifiedName());
                        }
                        return pattern.matcher(pkg.getQualifiedName()).matches();
                    }
                };
            }
        });
    }

    public String getExtensionId() {
        return "java-package";
    }
}

