/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.common;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.revapi.Difference;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaModelElement;

public abstract class ModifierChanged
extends CheckBase {
    private final boolean added;
    private final Code code;
    private final Modifier modifier;

    protected ModifierChanged(boolean added, Code code, Modifier modifier) {
        this.added = added;
        this.code = code;
        this.modifier = modifier;
    }

    protected final void doVisit(JavaModelElement oldElement, JavaModelElement newElement) {
        if (!this.isBothAccessible(oldElement, newElement)) {
            return;
        }
        boolean oldHas = oldElement.getDeclaringElement().getModifiers().contains((Object)this.modifier);
        boolean newHas = newElement.getDeclaringElement().getModifiers().contains((Object)this.modifier);
        if (this.added && !oldHas && newHas || !this.added && oldHas && !newHas) {
            this.pushActive((JavaElement)oldElement, (JavaElement)newElement, new Object[0]);
        }
    }

    protected List<Difference> doEnd() {
        CheckBase.ActiveElements elements = this.popIfActive();
        if (elements == null) {
            return null;
        }
        return Collections.singletonList(this.createDifference(this.code, Code.attachmentsFor((JavaElement)((JavaModelElement)elements.oldElement), (JavaElement)((JavaModelElement)elements.newElement), (String[])new String[]{"oldModifiers", ModifierChanged.stringify(((JavaModelElement)elements.oldElement).getDeclaringElement().getModifiers()), "newModifiers", ModifierChanged.stringify(((JavaModelElement)elements.newElement).getDeclaringElement().getModifiers())})));
    }

    public static String stringify(Set<Modifier> modifiers) {
        return modifiers.stream().sorted(Comparator.comparingInt(ModifierChanged::score)).map(m -> m.name().toLowerCase()).collect(Collectors.joining(" "));
    }

    private static int score(Modifier mod) {
        switch (mod) {
            case PUBLIC: {
                return 0;
            }
            case PRIVATE: {
                return 1;
            }
            case PROTECTED: {
                return 2;
            }
            case ABSTRACT: {
                return 3;
            }
            case STATIC: {
                return 4;
            }
            case FINAL: {
                return 5;
            }
            case TRANSIENT: {
                return 6;
            }
            case VOLATILE: {
                return 7;
            }
            case DEFAULT: {
                return 8;
            }
            case SYNCHRONIZED: {
                return 9;
            }
            case NATIVE: {
                return 10;
            }
            case STRICTFP: {
                return 11;
            }
        }
        return 12;
    }
}

