/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.compilation;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import org.revapi.java.compilation.ProbingEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ProbingAnnotationProcessor
extends AbstractProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ProbingAnnotationProcessor.class);
    private final ProbingEnvironment environment;
    private Runnable postCompilationPayload;

    public ProbingAnnotationProcessor(ProbingEnvironment env) {
        this.environment = env;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.environment.setProcessingEnvironment(this.processingEnv);
            this.postCompilationPayload.run();
            this.releaseCompilationProgress();
            try {
                this.environment.getCompilationTeardownLatch().await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton("__RevapiMarkerAnnotation");
    }

    public <T> Future<T> submitWithCompilationAwareness(ExecutorService executor, final Callable<T> compilation, final Runnable postCompilePayload) throws Exception {
        return executor.submit(new Callable<T>(){
            final /* synthetic */ ProbingAnnotationProcessor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public T call() throws Exception {
                try {
                    this.this$0.postCompilationPayload = postCompilePayload;
                    Object v = compilation.call();
                    return v;
                }
                finally {
                    this.this$0.releaseCompilationProgress();
                }
            }
        });
    }

    private void releaseCompilationProgress() {
        if (LOG.isTraceEnabled() && this.environment.getCompilationProgressLatch().getCount() > 0L) {
            LOG.trace("Releasing compilation progress for " + this.environment.getApi());
        }
        this.environment.getCompilationProgressLatch().countDown();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

