/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.matcher;

import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.revapi.ArchiveAnalyzer;
import org.revapi.Element;
import org.revapi.ElementMatcher;
import org.revapi.FilterStartResult;
import org.revapi.Ternary;
import org.revapi.TreeFilter;
import org.revapi.base.BaseElementMatcher;
import org.revapi.base.IndependentTreeFilter;
import org.revapi.java.JavaArchiveAnalyzer;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaModelElement;
import org.revapi.java.spi.JavaTypeElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageMatcher
extends BaseElementMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(PackageMatcher.class);

    public Optional<ElementMatcher.CompiledRecipe> compile(final String recipe) {
        return Optional.of(new ElementMatcher.CompiledRecipe(){
            final Pattern pattern;
            final /* synthetic */ PackageMatcher this$0;
            {
                this.this$0 = this$0;
                this.pattern = recipe.length() > 1 && recipe.startsWith("/") && recipe.endsWith("/") ? Pattern.compile(recipe.substring(1, recipe.length() - 1)) : null;
            }

            @Nullable
            public <E extends Element<E>> TreeFilter<E> filterFor(ArchiveAnalyzer<E> archiveAnalyzer) {
                if (!(archiveAnalyzer instanceof JavaArchiveAnalyzer)) {
                    return null;
                }
                return new IndependentTreeFilter<JavaElement>(){

                    protected FilterStartResult doStart(JavaElement element) {
                        if (!(element instanceof JavaTypeElement)) {
                            return FilterStartResult.defaultResult();
                        }
                        JavaModelElement modelElement = (JavaModelElement)element;
                        PackageElement pkg = this.getPackage(modelElement);
                        Ternary ret = Ternary.fromBoolean((boolean)this.matches(pkg));
                        return FilterStartResult.direct((Ternary)ret, (Ternary)ret);
                    }

                    private PackageElement getPackage(JavaModelElement el) {
                        PackageElement pkg;
                        JavaTypeElement topLevelParent = this.getTopLevelParent(el);
                        TypeElement type = topLevelParent == null ? null : topLevelParent.getDeclaringElement();
                        PackageElement packageElement = pkg = el == null ? null : el.getTypeEnvironment().getElementUtils().getPackageOf(type);
                        if (pkg == null && el != null) {
                            LOG.warn("Could not find the package of type {} represented by an instance of type {}", (Object)el, (Object)el.getClass());
                        }
                        return pkg;
                    }

                    private boolean matches(PackageElement pkg) {
                        if (pattern == null) {
                            return recipe.contentEquals(pkg.getQualifiedName());
                        }
                        return pattern.matcher(pkg.getQualifiedName()).matches();
                    }

                    private JavaTypeElement getTopLevelParent(JavaModelElement el) {
                        while (!(el == null || el instanceof JavaTypeElement && el.getParent() == null)) {
                            el = el.getParent();
                        }
                        return (JavaTypeElement)el;
                    }
                };
            }
        });
    }

    public String getMatcherId() {
        return "java-package";
    }

    public String getExtensionId() {
        return "revapi.matcher.java-package";
    }
}

