/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.classes;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.revapi.Difference;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.Util;

public final class NoLongerImplementsInterface
extends CheckBase {
    @Override
    protected void doVisitClass(TypeElement oldType, TypeElement newType) {
        if (oldType == null || newType == null) {
            return;
        }
        if (NoLongerImplementsInterface.isBothPrivate(oldType, newType)) {
            return;
        }
        List<? extends TypeMirror> newInterfaces = newType.getInterfaces();
        for (TypeMirror typeMirror : oldType.getInterfaces()) {
            if (Util.isSubtype(typeMirror, newInterfaces, this.getOldTypeEnvironment().getTypeUtils())) continue;
            this.pushActive(oldType, newType, new Object[0]);
            break;
        }
    }

    @Override
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements types = this.popIfActive();
        if (types == null) {
            return null;
        }
        ArrayList<Difference> result = new ArrayList<Difference>();
        List<? extends TypeMirror> newInterfaces = ((TypeElement)types.newElement).getInterfaces();
        for (TypeMirror typeMirror : ((TypeElement)types.oldElement).getInterfaces()) {
            if (Util.isSubtype(typeMirror, newInterfaces, this.getOldTypeEnvironment().getTypeUtils())) continue;
            result.add(this.createDifference(Code.CLASS_NO_LONGER_IMPLEMENTS_INTERFACE, (Object[])new String[]{Util.toHumanReadableString(typeMirror)}, new Object[]{typeMirror}));
        }
        return result;
    }
}

