/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.compilation;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.revapi.java.compilation.ProbingEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompilationValve {
    private static final Logger LOG = LoggerFactory.getLogger(CompilationValve.class);
    private final Future<Boolean> compilationResult;
    private final File dirToCleanup;
    private final ProbingEnvironment environment;

    CompilationValve(Future<Boolean> results, File dirToCleanup, ProbingEnvironment env) {
        this.compilationResult = results;
        this.dirToCleanup = dirToCleanup;
        this.environment = env;
    }

    ProbingEnvironment getEnvironment() {
        return this.environment;
    }

    Future<Boolean> getCompilationResult() {
        return this.compilationResult;
    }

    public void removeCompiledResults() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Releasing compilation environment for " + this.environment.getApi());
        }
        this.environment.getCompilationTeardownLatch().countDown();
        if (!this.compilationResult.isDone()) {
            try {
                this.compilationResult.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("Exception thrown while waiting for compilation to end for clean up", e);
            }
        }
        try {
            Files.walkFileTree(this.dirToCleanup.toPath(), (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    if (CompilationValve.this.dirToCleanup.toPath().equals(file)) {
                        return FileVisitResult.CONTINUE;
                    }
                    throw new IOException("Failed to delete file '" + file + "'.", exc);
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to remove compiled results", e);
        }
    }
}

