/*
 * Copyright 2014 Lukas Krejci
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
 */

package org.revapi.java.model;

import javax.annotation.Nonnull;
import javax.lang.model.element.VariableElement;

import org.revapi.Archive;
import org.revapi.java.compilation.ProbingEnvironment;
import org.revapi.java.spi.JavaFieldElement;

/**
 * @author Lukas Krejci
 * @since 0.1
 */
public final class FieldElement extends JavaElementBase<VariableElement> implements JavaFieldElement {

    public FieldElement(ProbingEnvironment env, Archive archive, VariableElement element) {
        super(env, archive, element);
    }

    @Nonnull
    @Override
    protected String getHumanReadableElementType() {
        return "field";
    }

    @Override
    protected String createComparableSignature() {
        return getModelElement().getSimpleName().toString();
    }
}
