/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.fields;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import org.revapi.Difference;
import org.revapi.java.checks.fields.BothFieldsRequiringCheck;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;

public class EnumConstantsOrderChanged
extends BothFieldsRequiringCheck {
    private boolean isEnumClass;

    @Override
    protected void doVisitClass(@Nullable TypeElement oldType, @Nullable TypeElement newType) {
        this.isEnumClass = newType != null && newType.getKind() == ElementKind.ENUM;
    }

    @Override
    protected boolean shouldCheck(VariableElement oldField, VariableElement newField) {
        return this.isEnumClass && super.shouldCheck(oldField, newField) && oldField.getKind() == ElementKind.ENUM_CONSTANT && newField.getKind() == ElementKind.ENUM_CONSTANT;
    }

    @Override
    protected void doVisitField(@Nullable VariableElement oldField, @Nullable VariableElement newField) {
        if (!this.shouldCheck(oldField, newField)) {
            return;
        }
        Predicate<VariableElement> isNotEnumConstant = v -> v.getKind() != ElementKind.ENUM_CONSTANT;
        List<VariableElement> fields = ElementFilter.fieldsIn(oldField.getEnclosingElement().getEnclosedElements());
        fields.removeIf(isNotEnumConstant);
        int oldIdx = fields.indexOf(oldField);
        fields = ElementFilter.fieldsIn(newField.getEnclosingElement().getEnclosedElements());
        fields.removeIf(isNotEnumConstant);
        int newIdx = fields.indexOf(newField);
        if (newIdx != oldIdx) {
            this.pushActive(oldField, newField, oldIdx, newIdx);
        }
    }

    @Override
    @Nullable
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements fields = this.popIfActive();
        if (fields == null) {
            return null;
        }
        int oldIdx = (Integer)fields.context[0];
        int newIdx = (Integer)fields.context[1];
        return Collections.singletonList(this.createDifference(Code.FIELD_ENUM_CONSTANT_ORDER_CHANGED, oldIdx, newIdx));
    }
}

