/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.fields;

import java.util.Collections;
import java.util.List;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.revapi.Difference;
import org.revapi.java.checks.fields.BothFieldsRequiringCheck;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.Util;

public final class TypeChanged
extends BothFieldsRequiringCheck {
    protected void doVisitField(VariableElement oldField, VariableElement newField) {
        String newType;
        if (!this.shouldCheck(oldField, newField)) {
            return;
        }
        String oldType = Util.toUniqueString((TypeMirror)oldField.asType());
        if (!oldType.equals(newType = Util.toUniqueString((TypeMirror)newField.asType()))) {
            this.pushActive(oldField, newField, new Object[0]);
        }
    }

    protected List<Difference> doEnd() {
        CheckBase.ActiveElements fields = this.popIfActive();
        if (fields == null) {
            return null;
        }
        String oldType = Util.toHumanReadableString((AnnotatedConstruct)((VariableElement)fields.oldElement).asType());
        String newType = Util.toHumanReadableString((AnnotatedConstruct)((VariableElement)fields.newElement).asType());
        return Collections.singletonList(this.createDifference(Code.FIELD_TYPE_CHANGED, new String[]{oldType, newType}, new Object[]{((VariableElement)fields.oldElement).asType(), ((VariableElement)fields.newElement).asType()}));
    }
}

