/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.classes;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.revapi.Difference;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.Util;

public final class NoLongerImplementsInterface
extends CheckBase {
    protected void doVisitClass(TypeElement oldType, TypeElement newType) {
        if (oldType == null || newType == null) {
            return;
        }
        List newInterfaces = Util.getAllSuperInterfaces((Types)this.getNewTypeEnvironment().getTypeUtils(), (TypeMirror)newType.asType());
        List oldInterfaces = Util.getAllSuperInterfaces((Types)this.getOldTypeEnvironment().getTypeUtils(), (TypeMirror)oldType.asType());
        for (TypeMirror oldIface : oldInterfaces) {
            if (Util.isSubtype((TypeMirror)oldIface, (List)newInterfaces, (Types)this.getOldTypeEnvironment().getTypeUtils())) continue;
            this.pushActive(oldType, newType, new Object[]{oldInterfaces, newInterfaces});
            break;
        }
    }

    protected List<Difference> doEnd() {
        CheckBase.ActiveElements types = this.popIfActive();
        if (types == null) {
            return null;
        }
        ArrayList<Difference> result = new ArrayList<Difference>();
        List oldInterfaces = (List)types.context[0];
        List newInterfaces = (List)types.context[1];
        for (TypeMirror oldIface : oldInterfaces) {
            if (Util.isSubtype((TypeMirror)oldIface, (List)newInterfaces, (Types)this.getOldTypeEnvironment().getTypeUtils())) continue;
            result.add(this.createDifference(Code.CLASS_NO_LONGER_IMPLEMENTS_INTERFACE, new String[]{Util.toHumanReadableString((AnnotatedConstruct)oldIface)}, new Object[]{oldIface}));
        }
        return result;
    }
}

