/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.compilation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.revapi.java.compilation.InnerClass;

final class InnerClassHierarchyConstructor {
    private final TreeSet<OuterNameInnerNamePair> innerNames = new TreeSet();

    InnerClassHierarchyConstructor() {
    }

    public void addName(String outerName, String innerName) {
        this.innerNames.add(new OuterNameInnerNamePair(outerName, innerName));
    }

    public List<InnerClass> process() {
        if (this.innerNames.isEmpty()) {
            return Collections.emptyList();
        }
        Iterator<OuterNameInnerNamePair> it = this.innerNames.iterator();
        OuterNameInnerNamePair names = it.next();
        if (names.outerName == null || names.innerName == null) {
            return Collections.emptyList();
        }
        String rootOwner = names.outerName.replace('/', '.');
        StringBuilder binaryName = new StringBuilder(rootOwner);
        StringBuilder canonicalName = new StringBuilder(rootOwner);
        ArrayList<InnerClass> result = new ArrayList<InnerClass>();
        result.add(new InnerClass(binaryName.toString(), canonicalName.toString()));
        while (true) {
            if (names.outerName == null || names.innerName == null) {
                return Collections.emptyList();
            }
            String name = names.innerName;
            binaryName.append('$').append(name);
            canonicalName.append('.').append(name);
            result.add(new InnerClass(binaryName.toString(), canonicalName.toString()));
            if (!it.hasNext()) break;
            names = it.next();
        }
        return result;
    }

    private static class OuterNameInnerNamePair
    implements Comparable<OuterNameInnerNamePair> {
        final String outerName;
        final String innerName;

        private OuterNameInnerNamePair(String outerName, String innerName) {
            this.outerName = outerName;
            this.innerName = innerName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OuterNameInnerNamePair that = (OuterNameInnerNamePair)o;
            if (this.outerName != null ? !this.outerName.equals(that.outerName) : that.outerName != null) {
                return false;
            }
            return !(this.innerName != null ? !this.innerName.equals(that.innerName) : that.innerName != null);
        }

        public int hashCode() {
            int result = this.outerName != null ? this.outerName.hashCode() : 0;
            result = 31 * result + (this.innerName != null ? this.innerName.hashCode() : 0);
            return result;
        }

        @Override
        public int compareTo(@Nonnull OuterNameInnerNamePair o) {
            int ret = OuterNameInnerNamePair.safeCompare(this.outerName, o.outerName);
            return ret != 0 ? ret : OuterNameInnerNamePair.safeCompare(this.innerName, o.innerName);
        }

        private static int safeCompare(String a, String b) {
            int ret = a == null ? (b == null ? 0 : 1) : (b == null ? -1 : a.compareTo(b));
            return ret;
        }
    }
}

