/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.model;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;
import org.revapi.API;
import org.revapi.Archive;
import org.revapi.Element;
import org.revapi.java.compilation.ProbingEnvironment;
import org.revapi.java.model.JavaElementFactory;
import org.revapi.java.spi.JavaAnnotationElement;
import org.revapi.java.spi.TypeEnvironment;
import org.revapi.java.spi.Util;
import org.revapi.simple.SimpleElement;

public final class AnnotationElement
extends SimpleElement
implements JavaAnnotationElement {
    private final AnnotationMirror annotation;
    private final ProbingEnvironment environment;
    private final Archive archive;
    private String comparableSignature;

    public AnnotationElement(ProbingEnvironment environment, Archive archive, AnnotationMirror annotation) {
        this.environment = environment;
        this.annotation = annotation;
        this.archive = archive;
    }

    @Nonnull
    public API getApi() {
        return this.environment.getApi();
    }

    @Nullable
    public Archive getArchive() {
        return this.archive;
    }

    @Override
    @Nonnull
    public AnnotationMirror getAnnotation() {
        return this.annotation;
    }

    @Override
    @Nonnull
    public TypeEnvironment getTypeEnvironment() {
        return this.environment;
    }

    public int compareTo(@Nonnull Element o) {
        if (!(o instanceof AnnotationElement)) {
            return JavaElementFactory.compareByType(this, o);
        }
        return this.getComparableSignature().compareTo(((AnnotationElement)o).getComparableSignature());
    }

    @Nonnull
    public String getFullHumanReadableString() {
        return Util.toHumanReadableString(this.annotation);
    }

    public String toString() {
        return this.getFullHumanReadableString();
    }

    private String getComparableSignature() {
        if (this.comparableSignature == null) {
            this.comparableSignature = "@" + Util.toHumanReadableString(this.annotation.getAnnotationType());
        }
        return this.comparableSignature;
    }
}

