/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.filters;

import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jboss.dmr.ModelNode;
import org.revapi.AnalysisContext;
import org.revapi.Element;
import org.revapi.ElementFilter;
import org.revapi.java.spi.JavaModelElement;
import org.revapi.java.spi.Util;

public final class IgnoreByAnnotationFilter
implements ElementFilter {
    private String[] fullMatches;
    private Pattern[] patterns;
    private boolean doNothing;
    private final IdentityHashMap<Object, Boolean> elementResults = new IdentityHashMap();

    public void close() throws Exception {
        this.elementResults.clear();
    }

    @Nullable
    public String[] getConfigurationRootPaths() {
        return new String[]{"revapi.java.ignore.annotated"};
    }

    public Reader getJSONSchema(@Nonnull String configurationRootPath) {
        if ("revapi.java.ignore.annotations".equals(configurationRootPath)) {
            return new InputStreamReader(this.getClass().getResourceAsStream("/META-INF/ignore-by-annos-schema.json"), Charset.forName("UTF-8"));
        }
        return null;
    }

    public void initialize(@Nonnull AnalysisContext analysisContext) {
        ModelNode root = analysisContext.getConfiguration().get(new String[]{"revapi", "java", "ignore", "annotated"});
        if (!root.isDefined()) {
            this.doNothing = true;
            return;
        }
        ModelNode regex = root.get("regex");
        boolean regexes = regex.isDefined() && regex.asBoolean();
        ArrayList<String> fullMatches = regexes ? null : new ArrayList<String>();
        ArrayList<Pattern> patterns = regexes ? new ArrayList<Pattern>() : null;
        ModelNode annotations = root.get("annotations");
        for (ModelNode ann : annotations.asList()) {
            String name = ann.asString();
            if (regexes) {
                patterns.add(Pattern.compile(name));
                continue;
            }
            fullMatches.add(name);
        }
        this.fullMatches = fullMatches == null ? null : fullMatches.toArray(new String[fullMatches.size()]);
        Pattern[] patternArray = this.patterns = patterns == null ? null : patterns.toArray(new Pattern[patterns.size()]);
        if (fullMatches != null) {
            Collections.sort(fullMatches);
        }
        this.doNothing = this.fullMatches != null && this.fullMatches.length == 0 || this.patterns != null && this.patterns.length == 0;
    }

    public boolean applies(@Nullable Element element) {
        return this.decide(element);
    }

    public boolean shouldDescendInto(@Nullable Object element) {
        return this.decide(element);
    }

    private boolean decide(@Nullable Object element) {
        if (this.doNothing || !(element instanceof JavaModelElement)) {
            return true;
        }
        Boolean ret = this.elementResults.get(element);
        if (ret != null) {
            return ret;
        }
        Predicate<String> test = this.fullMatches == null ? s -> Stream.of(this.patterns).anyMatch(p -> p.matcher((CharSequence)s).matches()) : s -> Arrays.binarySearch(this.fullMatches, s) >= 0;
        JavaModelElement javaElement = (JavaModelElement)element;
        ret = !javaElement.getModelElement().getAnnotationMirrors().stream().map(Util::toHumanReadableString).anyMatch(test);
        this.elementResults.put(element, ret);
        return ret;
    }
}

